/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.query.apply;

import java.util.ArrayList;
import java.util.List;

import org.apache.olingo.server.api.uri.queryoption.apply.GroupBy;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupByItem;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.transformation.CqnGroupByTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;

public class GroupByTransformation implements CqnGroupByTransformation {

	private final List<CqnElementRef> dimensions;
	private final List<CqnTransformation> transformations = new ArrayList<>();

	public GroupByTransformation(GroupBy gBy, ExpressionParser expressionParser) {
		// group by dimensions
		List<GroupByItem> gByItems = gBy.getGroupByItems();
		dimensions = new ArrayList<>(gByItems.size());
		for (GroupByItem gByItem : gByItems) {
			ElementRef<?> ref = CQL.get(expressionParser.toSegmentList(gByItem.getPath()));
			dimensions.add(ref.as(ref.path()));
		}


		if (gBy.getApplyOption() != null) {
			// handle aggregations
			ApplyHandler applyHandler = ApplyHandler.create(gBy.getApplyOption(), expressionParser);
			transformations.addAll(applyHandler.getTransformations(0));
		}
	}

	@Override
	public List<CqnElementRef> dimensions() {
		return dimensions;
	}

	@Override
	public List<CqnTransformation> transformations() {
		return transformations;
	}

}
