/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json;

import java.io.IOException;
import java.util.Map;

import org.apache.olingo.commons.api.Constants;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.Number2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.String2Json;
import com.sap.cds.impl.parser.token.Jsonizer;

public class Apply2Json implements Data2Json<Iterable<Map<String, Object>>> {

	String2Json<Void> context;
	String2Json<Void> metadataEtag;
	Number2Json<Iterable<Map<String, Object>>> count;
	String2Json<Void> nextLink;

	Apply2Json() {
	}

	@Override
	public void toJson(Iterable<Map<String, Object>> rows, JsonGenerator json) throws IOException {
		json.writeStartObject();
		if (context != null) {
			context.toJson(null, json);
		}
		if (metadataEtag != null) {
			metadataEtag.toJson(null, json);
		}		
		if (count != null) {
			count.toJson(rows, json);
		}
		if (nextLink != null) {
			nextLink.toJson(null, json);
		}

		json.writeFieldName(Constants.VALUE);
		json.writeRawValue(Jsonizer.json(rows));

		json.writeEndObject();
	}
}
