/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json;

import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.format.ContentType;

import com.sap.cds.adapter.odata.v4.serializer.json.options.Struct2JsonOptions;

public class Complex2JsonBuilder extends Struct2JsonBuilder {

	protected Complex2Json complex2json;

	protected Complex2JsonBuilder(Struct2JsonOptions options, EdmStructuredType structType) {
		super(options, structType);
	}

	public static Complex2Json createRoot(
			Struct2JsonOptions options,
			EdmStructuredType structType,
			ContentType contentType) {

		Complex2JsonBuilder builder = new Complex2JsonBuilder(options, structType);
		return builder.create(contentType, true);
	}

	public static Complex2Json createNested(
			Struct2JsonOptions options,
			EdmStructuredType structType,
			ContentType contentType) {

		Complex2JsonBuilder builder = new Complex2JsonBuilder(options, structType);
		return builder.create(contentType, false);
	}

	private Complex2Json create(ContentType contentType, boolean isRootLevel) {
		this.contentType = contentType;
		this.constants = options.getConstants();
		this.metadata = options.getGlobals().getServiceMetadata();

		this.complex2json = new Complex2Json();
		this.complex2json.isRootLevel = isRootLevel;
		this.complex2json.isOpenType = this.structType.isOpenType();

		createSelectList();
		addContextAnnotation(complex2json, false);
		addTypeAnnotation(complex2json);

		if (options.getWriteOnlyReferences()) {
			return complex2json;
		}

		createProperties(complex2json);
		return complex2json;
	}

	@Override
	protected void addNavigationLink(String navigationPropertyName) {
		// calculated only for entities
	}
}
