/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json;

import java.io.IOException;
import java.util.Map;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.options.CdsODataOptions;

public class InlineCount2Json extends NavigationProperty2Json {

	private final CdsODataOptions options;

	public InlineCount2Json(String name, CdsODataOptions options) {
		this.navigationProperty = name;
		this.options = options;
	}

	@Override
	public void toJson(Map<String, Object> data, JsonGenerator json) throws IOException {
		String counterName = navigationProperty.concat("@count"); // TODO adapt, once representation in CDS4j is changed
		if (data.containsKey(counterName) && data.get(counterName) instanceof Long count) {
			String resultCounterName = navigationProperty + options.getConstants().getCount();
			if (options.isIEEE754Compatible()) {
				json.writeStringField(resultCounterName, count.toString());
			} else {
				json.writeNumberField(resultCounterName, count);
			}
			data.remove(counterName);
		}
	}
}
