/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json;

import java.io.IOException;
import java.util.Map;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.String2Json;

public class Primitive2Json implements Data2Json<Map<String, Object>> {

	String2Json<Void> context;
	String2Json<Void> metadataEtag;
	Data2Json<Map<String, Object>> primitiveProperty;

	Primitive2Json() {
	}

	public String2Json<Void> getContext() {
		return context;
	}

	public String2Json<Void> getMetadataEtag() {
		return metadataEtag;
	}

	@Override
	public void toJson(Map<String, Object> row, JsonGenerator json) throws IOException {
		if (row == null) {
			json.writeNull();
			return;
		}

		json.writeStartObject();
		if (context != null) {
			context.toJson(null, json);
		}
		if (metadataEtag != null) {
			metadataEtag.toJson(null, json);
		}
		if (primitiveProperty != null) {
			primitiveProperty.toJson(row, json);
		}
		json.writeEndObject();
	}
}
