/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.options;

import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.format.ContentType;

import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;

/**
 * Options for the primitive serializers.
 */
public class Primitive2JsonOptions extends CdsODataOptions {

	/** Gets the {@link ContextURL}. */
	public ContextURL getContextURL() {
		return contextURL;
	}

	private Primitive2JsonOptions(ContentType contentType, String odataVersion, CdsRequestGlobals globals) {
		super(contentType, odataVersion, globals);
	}

	/** Initializes the options builder. */
	public static Builder with(ContentType contentType, String odataVersion, CdsRequestGlobals globals) {
		return new Builder(contentType, odataVersion, globals);
	}

	/** Builder of OData serializer options. */
	public static final class Builder {

		private final Primitive2JsonOptions options;

		private Builder(ContentType contentType, String odataVersion, CdsRequestGlobals globals) {
			options = new Primitive2JsonOptions(contentType, odataVersion, globals);
		}

		/** Sets the {@link ContextURL}. */
		public Builder contextURL(ContextURL contextURL) {
			options.contextURL = contextURL;
			return this;
		}

		/** Builds the OData serializer options. */
		public Primitive2JsonOptions build() {
			return options;
		}
	}
}
