/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;

public class Decimal2Json<T> implements Data2Json<T> {

	private final String name;
	private final Function<T, Number> valueFunc;

	private Decimal2Json(String name, Function<T, Number> valueFunc) {
		this.name = name;
		this.valueFunc = valueFunc;
	}

	public static <T> Decimal2Json<T> val(String name, Function<T, Number> valueFunc) {
		return new Decimal2Json<T>(name, valueFunc);
	}

	public static <T> Decimal2Json<T> val(String name, BigDecimal value) {
		return new Decimal2Json<>(name, fixed -> value);
	}

	@Override
	public void toJson(T data, JsonGenerator json) throws IOException {
		Number num = valueFunc.apply(data);
		json.writeFieldName(name);
		if (num != null) {
			BigDecimal value = new BigDecimal(num.toString());
			json.writeNumber(value);
		} else {
			json.writeNull();
		}
	}

	@Override
	public Object getValue(T data) {
		return valueFunc.apply(data);
	}

	@Override
	public String getName() {
		return name;
	}	
}
