/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;

public class DecimalArray2Json<T> implements Data2Json<T> {

	private final String name;
	private final Function<T, List<BigDecimal>> valueFunc;

	private DecimalArray2Json(String name, Function<T, List<BigDecimal>> valueFunc) {
		this.name = name;
		this.valueFunc = valueFunc;
	}

	public static <T> DecimalArray2Json<T> val(String name, Function<T, List<BigDecimal>> valueFunc) {
		return new DecimalArray2Json<T>(name, valueFunc);
	}

	@Override
	public void toJson(T data, JsonGenerator json) throws IOException {
		List<BigDecimal> values = valueFunc.apply(data);
		json.writeFieldName(name);
		json.writeStartArray();
		if (values != null) {
			for (BigDecimal v : values) {
				if (v != null) {
					json.writeNumber(v);
				} else {
					json.writeNull();
				}
			}
		}
		json.writeEndArray();
	}

	@Override
	public String getName() {
		return name;
	}
}
