/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;

public class Stream2Json<T> implements Data2Json<T> {

	private final String name;
	private final Function<T, Closeable> valueFunc;

	private Stream2Json(String name, Function<T, Closeable> valueFunc) {
		this.name = name;
		this.valueFunc = valueFunc;
	}

	public static <T> Stream2Json<T> val(String name, Function<T, Closeable> valueFunc) {
		return new Stream2Json<T>(name, valueFunc);
	}

	@Override
	public void toJson(T data, JsonGenerator json) throws IOException {
		Closeable stream = valueFunc.apply(data);
		json.writeFieldName(name);
		if (null == stream) {
			json.writeNull();
		} else {
			if (stream instanceof Reader reader) {
				json.writeString(reader, -1);
			} else if (stream instanceof InputStream inputStream) {
				json.writeBinary(inputStream, -1);
			} else {
				throw new IllegalArgumentException(
						"Stream of type '%s' not supported".formatted(stream.getClass().getName()));
			}
		}
	}

	@Override
	public Object getValue(T data) {
		return valueFunc.apply(data);
	}

	@Override
	public String getName() {
		return name;
	}
}
