/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.utils.StringUtils;

public class ElementUtils {

	public static StructuredType<?> aliasedTo(String path) {
		if (path.contains(".")) {
			// TODO rather use expands
			// however much more complex as it might need to be merged with other expands
			return CQL.to(path).as(path);
		}
		return CQL.to(path);
	}

	public static CqnSelectListValue aliasedGet(String path) {
		if (path.contains(".")) {
			// TODO rather use expands
			// however much more complex as it might need to be merged with other expands
			return CQL.get(path).as(path);
		} else {
			return CQL.get(path);
		}
	}

	public static Map<String, CdsElement> recursiveElements(CdsStructuredType type) {
		return recursiveElements(type, e -> true);
	}

	public static Map<String, CdsElement> recursiveElements(CdsStructuredType type,
			Predicate<? super CdsElement> filter) {
		Map<String, CdsElement> elements = new LinkedHashMap<>();
		type.elements().forEach(e -> collectElements(elements, null, e, filter));
		return elements;
	}

	private static void collectElements(Map<String, CdsElement> elements, String path,
			CdsElement element, Predicate<? super CdsElement> filter) {
		if (element.getType().isStructured()) {
			String elementPath = join(path, element.getName());
			element.getType().as(CdsStructuredType.class).elements()
					.forEach(e -> collectElements(elements, elementPath, e, filter));
		} else if (filter.test(element)) {
			String elementPath = join(path, element.getName());
			elements.put(elementPath, element);
		}
	}

	private static String join(String path, String id) {
		if (StringUtils.isEmpty(path)) {
			return id;
		} else {
			return path + "." + id;
		}
	}

}
