/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.utils.mapper;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;

public class NoopEdmxFlavourMapper implements EdmxFlavourMapper {

	@Override
	public String remap(String element, CdsStructuredType type) {
		return element;
	}

	@Override
	public <T extends Iterable<? extends Map<String, Object>>> T remap(T entry,
			CdsStructuredType entryType, Function<String, Boolean> isExpanded) {
		return entry;
	}

	@Override
	public Stream<? extends Mapping> createMappings(CdsStructuredType type) {
		return type.elements().map(MappingNoop::new);
	}

	private static class MappingNoop implements Mapping {

		private final CdsElement element;

		public MappingNoop(CdsElement element) {
			this.element = element;
		}

		@Override
		public CdsElement getTargetElement() {
			return element;
		}

		@Override
		public CdsElement getRootElement() {
			return element;
		}

		@Override
		public String getEdmxName() {
			return element.getName();
		}

		@Override
		public String getCsnName() {
			return element.getName();
		}

	}

}
