/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;

class EdmxI18nInputStream
extends InputStream {
    private static final int[] IPATTERN = new int[]{123, 105, 49, 56, 110, 62};
    private final Map<String, String> i18n;
    private final BufferedInputStream buffer;
    private byte[] replacement;
    private int replacementOffset;

    public EdmxI18nInputStream(InputStream is, Map<String, String> i18n) {
        this.buffer = new BufferedInputStream(is);
        this.i18n = i18n == null ? Collections.emptyMap() : i18n;
    }

    @Override
    public int read() throws IOException {
        if (this.replacement != null) {
            if (this.replacementOffset < this.replacement.length) {
                return this.replacement[this.replacementOffset++] & 0xFF;
            }
            this.replacement = null;
        }
        if (this.lookAhead()) {
            return this.read();
        }
        return this.buffer.read();
    }

    private boolean lookAhead() throws IOException {
        int cc;
        this.buffer.mark(IPATTERN.length);
        for (int i = 0; i < IPATTERN.length; ++i) {
            if (this.buffer.read() == IPATTERN[i]) continue;
            this.buffer.reset();
            return false;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        while ((cc = this.buffer.read()) >= 0) {
            if (cc == 125) {
                String i18nKey = result.toString(StandardCharsets.UTF_8);
                this.replacementOffset = 0;
                if (!this.i18n.containsKey(i18nKey)) {
                    this.buffer.reset();
                    return false;
                }
                this.replacement = this.i18n.get(i18nKey).getBytes(StandardCharsets.UTF_8);
                return true;
            }
            result.write(cc);
        }
        this.buffer.reset();
        return false;
    }
}

