/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ServiceMetadata;

import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper.EdmxFlavour;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.runtime.CdsRuntime;

public class CdsRequestGlobals {

	private final CdsRuntime runtime;
	private final CdsModel model;
	private final AtomicBoolean unclosedChangeSetTracker;
	private final Map<String, String> cdsEntityNames = new HashMap<>();
	private final EdmxFlavour edmxFlavour;
	private ApplicationService service;
	private OData odata;
	private ServiceMetadata serviceMetadata;


	public CdsRequestGlobals(CdsRuntime runtime, CdsModel model, AtomicBoolean unclosedChangeSetTracker) {
		this.runtime = runtime;
		this.model = model;
		this.unclosedChangeSetTracker = unclosedChangeSetTracker;
		// TODO https://github.wdf.sap.corp/cds-java/home/issues/205: determine this based on the model / EDMX
		// TODO https://github.wdf.sap.corp/cds-java/home/issues/206: map message targets -> duplicate messages in case target refers to foreignKey?
		// TODO https://github.wdf.sap.corp/cds-java/home/issues/204: revisit putting of targetKeyValues() obtained from CqnAnalyzer
		// TODO https://github.wdf.sap.corp/cds-java/home/issues/204: revisit iterating over keyElements -> Navigate into StructuredTypes & Association Keys
		this.edmxFlavour = runtime.getEnvironment().getCdsProperties().getModel().getUniversalCsn().isEnabled() ? EdmxFlavour.V4 : EdmxFlavour.NOOP;
	}

	public CdsRuntime getRuntime() {
		return runtime;
	}

	public CdsModel getModel() {
		return model;
	}

	public AtomicBoolean getUnclosedChangeSetTracker() {
		return unclosedChangeSetTracker;
	}

	public Map<String, String> getCdsEntityNames() {
		return cdsEntityNames;
	}

	public EdmxFlavour getEdmxFlavour() {
		return edmxFlavour;
	}

	public ApplicationService getApplicationService() {
		return service;
	}

	public void setApplicationService(ApplicationService service) {
		this.service = service;
	}

	public ServiceMetadata getServiceMetadata() {
		return serviceMetadata;
	}

	public void setServiceMetadata(ServiceMetadata serviceMetadata) {
		this.serviceMetadata = serviceMetadata;
	}

	public OData getOData() {
		return odata;
	}

	public void setOData(OData odata) {
		this.odata = odata;
	}
}
