/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.ql.cqn.CqnSelect;

public class LimitCalculator {

	private long skip;
	private long top;

	private LimitCalculator(long top, long skip) {
		this.skip = skip;
		this.top = top;
	}

	public static LimitCalculator of(CqnSelect select) {
		return select.hasLimit() ? of(select.top(), select.skip()) : initial();
	}

	public static LimitCalculator initial() {
		return new LimitCalculator(Integer.MAX_VALUE, 0l);
	}

	public LimitCalculator top(long rows) {
		if (rows < this.top) {
			top = rows;
		}

		return this;
	}

	public LimitCalculator skip(long rows) {
		skip += rows;
		top -= rows;

		return this;
	}

	public long top() {
		return top;
	}

	public long skip() {
		return skip;
	}

	public static LimitCalculator of(long top, long skip) {
		return new LimitCalculator(top, skip);
	}

}
