/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.query.apply;

import static com.sap.cds.ql.CQL.sort;
import static com.sap.cds.ql.cqn.CqnSortSpecification.Order.ASC;
import static com.sap.cds.ql.cqn.CqnSortSpecification.Order.DESC;

import java.util.ArrayList;
import java.util.List;

import org.apache.olingo.server.api.uri.queryoption.OrderByItem;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.apply.OrderBy;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.transformation.CqnOrderByTransformation;

public class OrderByTransformation implements CqnOrderByTransformation {

	private final List<CqnSortSpecification> sortList;

	public OrderByTransformation(OrderByOption orderBy, ExpressionParser expressionParser) {
		sortList = convertToAliasedSortList(orderBy, expressionParser);
	}

	public OrderByTransformation(OrderBy orderBy, ExpressionParser expressionParser) {
		this(orderBy.getOrderByOption(), expressionParser);
	}

	private static List<CqnSortSpecification> convertToAliasedSortList(OrderByOption orderBy,
			ExpressionParser expressionParser) {
		List<CqnSortSpecification> sortList = new ArrayList<>();
		for (OrderByItem order : orderBy.getOrders()) {
			CqnValue value = expressionParser.parseValue(order.getExpression());
			sortList.add(sort(value, order.isDescending() ? DESC : ASC));
		}
		return sortList;
	}

	@Override
	public List<CqnSortSpecification> orderBy() {
		return sortList;
	}

}
