/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json;

import java.net.URI;

import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.format.ContentType;

import com.sap.cds.adapter.odata.v4.serializer.json.options.Struct2JsonOptions;
import com.sap.cds.adapter.odata.v4.serializer.json.options.StructCollection2JsonOptions;

public class ComplexCollection2JsonBuilder extends StructCollection2JsonBuilder {

	public static ComplexCollection2Json createRoot(
			StructCollection2JsonOptions opts,
			EdmStructuredType entityType,
			ContentType contentType,
			URI nextLinkUri,
			long inlineCount) { // the overall count of the request, NOT the rowCount
		return create(opts, entityType, contentType, nextLinkUri, inlineCount, null);
	}

	public static ComplexCollection2Json createExpanded(
			StructCollection2JsonOptions opts,
			EdmStructuredType entityType,
			ContentType contentType,
			String navigationPropertyName) {
		return create(opts, entityType, contentType, null, null, navigationPropertyName);
	}

	private static ComplexCollection2Json create(
			StructCollection2JsonOptions options,
			EdmStructuredType entityType,
			ContentType contentType,
			URI nextLinkUri,
			Long inlineCount,
			String navigationPropertyName) {

		ComplexCollection2Json collection2Json = new ComplexCollection2Json();
		collection2Json.navigationPropertyName = navigationPropertyName;
		collection2Json.writeOnlyReferences = options.getWriteOnlyReferences();

		Struct2JsonOptions entityOptions = Struct2JsonOptions
				.with(contentType, options.getODataVersion(), options.getGlobals())
				.contextURL(options.getContextURL())
				.expand(options.getExpand())
				.select(options.getSelect())
				.writeOnlyReferences(options.getWriteOnlyReferences())
				.strictSerialization(options.isStrictSerialization())
				.build();

		collection2Json.entity2Json = Complex2JsonBuilder.createNested(entityOptions, entityType, contentType);
		addCountAndNextLink(collection2Json, options, nextLinkUri, navigationPropertyName, inlineCount);

		return collection2Json;
	}
}
