/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json;

import java.io.IOException;
import java.util.Map;

import com.fasterxml.jackson.core.JsonGenerator;

public class EntityCollection2Json extends StructCollection2Json {

	EntityCollection2Json() {
	}

	@Override
	protected void writeJsonArray(Iterable<Map<String, Object>> rows, JsonGenerator json) throws IOException {
		json.writeStartArray();
		if (rows != null) {
			for (Map<String, Object> row : rows) {
				if (writeOnlyReferences) {
					json.writeStartObject();
					((Entity2Json)entity2Json).id().toJson(row, json);
					json.writeEndObject();
				} else {
					entity2Json.toJson(row, json);
				}
			}
		}
		json.writeEndArray();
	}
}
