/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json;

import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.IConstants;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.core.serializer.utils.ContextURLBuilder;

import com.sap.cds.adapter.odata.v4.serializer.json.api.PropertyInfo;
import com.sap.cds.adapter.odata.v4.serializer.json.options.Primitive2JsonOptions;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.String2Json;

public final class Primitive2JsonBuilder {

	private final Primitive2JsonOptions options;
	private final PropertyInfo property;
	private Primitive2Json primitive2Json;
	private IConstants constants;

	private Primitive2JsonBuilder(Primitive2JsonOptions options, PropertyInfo property) {
		this.options = options;
		this.property = property;
	}

	public static Primitive2Json create(Primitive2JsonOptions options, PropertyInfo property, ContentType contentType) {
		Primitive2JsonBuilder builder = new Primitive2JsonBuilder(options, property);
		return builder.create(contentType);
	}

	private Primitive2Json create(ContentType contentType) {
		primitive2Json = new Primitive2Json();
		this.constants = options.getConstants();
		ServiceMetadata metadata = options.getGlobals().getServiceMetadata();
		if (options.getContextURL() != null) {
			if (!options.isODataMetadataNone()) {
				primitive2Json.context = String2Json.constant(constants.getContext(),
						ContextURLBuilder.create(options.getContextURL()).toASCIIString());
				if (metadata.getServiceMetadataETagSupport() != null
						&& metadata.getServiceMetadataETagSupport().getMetadataETag() != null) {
					primitive2Json.metadataEtag = String2Json.constant(constants.getMetadataEtag(),
							metadata.getServiceMetadataETagSupport().getMetadataETag());
				}
			}
			primitive2Json.primitiveProperty = StructTypeHelper.createPrimitive(property, Constants.VALUE, options);
		}
		return primitive2Json;
	}
}
