/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.api;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;

public interface Data2Json<T> {

	void toJson(T data, JsonGenerator json) throws IOException;

	default Object getValue(T data) {
		throw new IllegalAccessError("Not implemented");
	}

	default public String getName() {
		throw new IllegalAccessError("Not implemented");
	}
}
