/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.api;

import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;

public class PropertyInfo {
	private final String name;
	private final EdmType type;
	private final boolean isCollection;
	// if true serialize non-existing value as null, otherwise don't serilaize the value at all
	private final boolean strictSerialization;

	public static PropertyInfo from(EdmProperty edmProperty) {
		return from(edmProperty, true);
	}

	public static PropertyInfo from(EdmProperty edmProperty, boolean strictSerialization) {
		return new PropertyInfo(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(),
				strictSerialization);
	}

	public static PropertyInfo create(String name, EdmType type, boolean isCollection) {
		return new PropertyInfo(name, type, isCollection, true);
	}

	private PropertyInfo(String name, EdmType type, boolean isCollection, boolean strict) {
		this.name = name;
		this.type = type;
		this.isCollection = isCollection;
		this.strictSerialization = strict;
	}

	public String getName() {
		return name;
	}

	public EdmType getType() {
		return type;
	}

	public boolean isCollection() {
		return isCollection;
	}

	public boolean isStrictSerialization() {
		return strictSerialization;
	}
}
