package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.IOException;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.api.DataValue;

public abstract class AbstractPrimitiveData2Json<T, V> implements Data2Json<T> {

	protected final Function<T, DataValue<V>> valueFunc;

	public AbstractPrimitiveData2Json(Function<T, DataValue<V>> valueFunc) {
		this.valueFunc = valueFunc;
	}

	public void toJson(T data, JsonGenerator json) throws IOException {
		DataValue<V> tuple = valueFunc.apply(data);
		if (tuple.hasValue()) {
			write(tuple.value(), json);
		}
	};

	@Override
	public V getValue(T data) {
		return valueFunc.apply(data).value();
	}

	protected abstract void write(V value, JsonGenerator json) throws IOException;
}
