/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.IOException;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.DataValue;

public class Number2Json<T> extends AbstractPrimitiveData2Json<T, Number> {

	private final String name;

	private Number2Json(String name, Function<T, DataValue<Number>> valueFunc) {
		super(valueFunc);
		this.name = name;
	}

	public static <T> Number2Json<T> val(String name, Function<T, DataValue<Number>> valueFunc) {
		return new Number2Json<T>(name, valueFunc);
	}

	public static <T> Number2Json<T> constant(String name, Number value) {
		return new Number2Json<>(name, fixed -> DataValue.value(value));
	}

	@Override
	protected void write(Number value, JsonGenerator json) throws IOException {
		json.writeFieldName(name);
		if (value != null) {
			json.writeNumber(String.valueOf(value));
		} else {
			json.writeNull();
		}
	}

	@Override
	public String getName() {
		return name;
	}
}
