/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.serializer.json;

import com.sap.cds.adapter.odata.v4.processors.response.ResultSetProcessor;
import com.sap.cds.adapter.odata.v4.serializer.json.Entity2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.Struct2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.Struct2JsonBuilder;
import com.sap.cds.adapter.odata.v4.serializer.json.StructTypeHelper;
import com.sap.cds.adapter.odata.v4.serializer.json.api.DataValue;
import com.sap.cds.adapter.odata.v4.serializer.json.options.Struct2JsonOptions;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.String2Json;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.serializer.utils.ExpandSelectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Entity2JsonBuilder
extends Struct2JsonBuilder {
    private static final Logger logger = LoggerFactory.getLogger(Entity2JsonBuilder.class);
    private boolean keysAreSelected = true;
    private Entity2Json entity2json;

    protected Entity2JsonBuilder(Struct2JsonOptions options, EdmStructuredType entityType) {
        super(options, entityType);
    }

    public static Entity2Json createRoot(Struct2JsonOptions options, EdmStructuredType entityType, ContentType contentType) {
        Entity2JsonBuilder builder = new Entity2JsonBuilder(options, entityType);
        return builder.create(contentType, true);
    }

    public static Entity2Json createNested(Struct2JsonOptions options, EdmStructuredType entityType, ContentType contentType) {
        Entity2JsonBuilder builder = new Entity2JsonBuilder(options, entityType);
        return builder.create(contentType, false);
    }

    protected EdmEntityType structType() {
        return (EdmEntityType)this.structType;
    }

    private Entity2Json create(ContentType contentType, boolean isRootLevel) {
        this.contentType = contentType;
        this.constants = this.options.getConstants();
        this.metadata = this.options.getGlobals().getServiceMetadata();
        this.entity2json = new Entity2Json();
        this.entity2json.isRootLevel = isRootLevel;
        this.entity2json.keyPredicate = row -> this.getOrCreateKeyPredicate((Map<String, Object>)row);
        this.entity2json.isAutoExpand = this.options.isAutoExpand();
        this.entity2json.isOpenType = this.structType.isOpenType();
        this.createSelectList();
        this.addContextAnnotation(this.entity2json, true);
        this.calculateEntityId();
        this.addTypeAnnotation(this.entity2json);
        if (this.options.getWriteOnlyReferences()) {
            return this.entity2json;
        }
        this.createProperties(this.entity2json);
        this.entity2json.builder = this;
        return this.entity2json;
    }

    @Override
    protected void addTypeAnnotation(Struct2Json entity2json) {
        EdmStructuredType resolvedType = StructTypeHelper.resolveEntityType(this.metadata, this.structType, this.options.getDerivedTypeName());
        if (this.options.isODataMetadataFull() || !this.options.isODataMetadataNone() && !this.keysAreSelected && !resolvedType.equals(this.structType)) {
            entity2json.type = String2Json.constant(this.constants.getType(), "#" + this.structType().getFullQualifiedName().getFullQualifiedNameAsString());
        }
    }

    @Override
    protected void createSelectList() {
        if (!ExpandSelectHelper.isAll((SelectOption)this.options.getSelect())) {
            this.selected = ExpandSelectHelper.getSelectedPropertyNames((List)this.options.getSelect().getSelectItems());
            if (!this.selected.isEmpty()) {
                for (String key : this.structType().getKeyPredicateNames()) {
                    this.keysAreSelected = !this.selected.add(key) && this.keysAreSelected;
                }
            }
        }
    }

    private void calculateEntityId() {
        if (this.options.isODataMetadataFull() || this.options.getWriteOnlyReferences() || !this.options.isODataMetadataNone() && !this.keysAreSelected) {
            this.entity2json.id = String2Json.val(this.options.getConstants().getId(), row -> DataValue.value(this.getOrCreateId((Map<String, Object>)row)));
        }
    }

    @Override
    protected void addNavigationLink(String navigationPropertyName) {
        if (this.options.isODataMetadataFull()) {
            String2Json<Map> navigationLinkProperty = String2Json.val(navigationPropertyName + this.constants.getNavigationLink(), row -> DataValue.value(this.getOrCreateId((Map<String, Object>)row) + "/" + navigationPropertyName));
            if (this.entity2json.navigationLinkProperties == null) {
                this.entity2json.navigationLinkProperties = new ArrayList(this.structType.getNavigationPropertyNames().size());
            }
            this.entity2json.navigationLinkProperties.add(navigationLinkProperty);
        }
    }

    private static String getOrCreate(Map<String, Object> row, Function<Map<String, Object>, String> provider, Map<Map<String, Object>, String> calculated) {
        String value = calculated.get(row);
        if (value == null) {
            value = provider.apply(row);
            calculated.put(row, value);
        }
        return value;
    }

    public String getOrCreateKeyPredicate(Map<String, Object> row) {
        return Entity2JsonBuilder.getOrCreate(row, r -> ResultSetProcessor.getEntityId(this.structType(), r), this.entity2json.calculatedKeyPredicate);
    }

    public String getOrCreateId(Map<String, Object> row) {
        if (this.entity2json.bindingTarget == null) {
            this.entity2json.bindingTarget = this.options.getEdmUtils().getEdmBindingTarget(this.structType());
        }
        if (this.entity2json.bindingTarget == null) {
            String keyPredicate = ResultSetProcessor.getEntityId(this.structType(), row);
            String singletonOrTypeName = this.options.getContextURL() == null ? null : this.options.getContextURL().getEntitySetOrSingletonOrType();
            String entitySetName = singletonOrTypeName == null ? this.structType.getName() : singletonOrTypeName;
            return entitySetName + keyPredicate;
        }
        return Entity2JsonBuilder.getOrCreate(row, r -> {
            try {
                return new URI(this.entity2json.bindingTarget.getName() + this.getOrCreateKeyPredicate(row)).toASCIIString();
            }
            catch (URISyntaxException e) {
                logger.error("Failed to create URI of entity", (Throwable)e);
                return "<error>";
            }
        }, this.entity2json.calculatedId);
    }
}

