/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.api.DataValue;
import java.io.IOException;
import java.util.function.Function;

public abstract class AbstractPrimitiveData2Json<T, V>
implements Data2Json<T> {
    protected final Function<T, DataValue<V>> valueFunc;

    public AbstractPrimitiveData2Json(Function<T, DataValue<V>> valueFunc) {
        this.valueFunc = valueFunc;
    }

    @Override
    public void toJson(T data, JsonGenerator json) throws IOException {
        DataValue<V> tuple = this.valueFunc.apply(data);
        if (tuple.hasValue()) {
            this.write(tuple.value(), json);
        }
    }

    @Override
    public V getValue(T data) {
        return this.valueFunc.apply(data).value();
    }

    protected abstract void write(V var1, JsonGenerator var2) throws IOException;
}

