/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.DataValue;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.AbstractPrimitiveData2Json;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.function.Function;

public class Decimal2Json<T>
extends AbstractPrimitiveData2Json<T, Number> {
    private final String name;

    private Decimal2Json(String name, Function<T, DataValue<Number>> valueFunc) {
        super(valueFunc);
        this.name = name;
    }

    public static <T> Decimal2Json<T> val(String name, Function<T, DataValue<Number>> valueFunc) {
        return new Decimal2Json<T>(name, valueFunc);
    }

    public static <T> Decimal2Json<T> constant(String name, BigDecimal value) {
        return new Decimal2Json<Object>(name, fixed -> DataValue.value(value));
    }

    @Override
    protected void write(Number val, JsonGenerator json) throws IOException {
        json.writeFieldName(this.name);
        if (val != null) {
            BigDecimal value = new BigDecimal(val.toString());
            json.writeNumber(value);
        } else {
            json.writeNull();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

