/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.DataValue;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.AbstractPrimitiveData2Json;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;

public class DecimalArray2Json<T>
extends AbstractPrimitiveData2Json<T, List<BigDecimal>> {
    private final String name;

    private DecimalArray2Json(String name, Function<T, DataValue<List<BigDecimal>>> valueFunc) {
        super(valueFunc);
        this.name = name;
    }

    public static <T> DecimalArray2Json<T> val(String name, Function<T, DataValue<List<BigDecimal>>> valueFunc) {
        return new DecimalArray2Json<T>(name, valueFunc);
    }

    @Override
    protected void write(List<BigDecimal> values, JsonGenerator json) throws IOException {
        json.writeFieldName(this.name);
        json.writeStartArray();
        if (values != null) {
            for (BigDecimal v : values) {
                if (v != null) {
                    json.writeNumber(v);
                    continue;
                }
                json.writeNull();
            }
        }
        json.writeEndArray();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

