/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.DataValue;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.AbstractPrimitiveData2Json;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;

public class NumberArray2Json<T>
extends AbstractPrimitiveData2Json<T, List<Number>> {
    private final String name;

    private NumberArray2Json(String name, Function<T, DataValue<List<Number>>> valueFunc) {
        super(valueFunc);
        this.name = name;
    }

    public static <T> NumberArray2Json<T> val(String name, Function<T, DataValue<List<Number>>> valueFunc) {
        return new NumberArray2Json<T>(name, valueFunc);
    }

    @Override
    protected void write(List<Number> values, JsonGenerator json) throws IOException {
        json.writeFieldName(this.name);
        json.writeStartArray();
        if (values != null) {
            for (Number v : values) {
                if (v != null) {
                    json.writeNumber(String.valueOf(v));
                    continue;
                }
                json.writeNull();
            }
        }
        json.writeEndArray();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

