/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata;

import com.google.common.hash.Hashing;
import com.sap.cds.adapter.odata.v4.metadata.ODataEdmProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataInfo {
    private static Logger log = LoggerFactory.getLogger(MetadataInfo.class);
    private final byte[] edmxBytes;
    private final CsdlEdmProvider provider;
    private final String etag;

    public static MetadataInfo create(String serviceName, byte[] edmxBytes, CdsRuntime runtime) throws Exception {
        if (!MetadataInfo.isEmpty(edmxBytes)) {
            log.info("Loading OData V4 metadata for service '{}'", (Object)serviceName);
        }
        return new MetadataInfo(edmxBytes, runtime.getEnvironment().getCdsProperties().getOdataV4().getCdsToEdm().isEnabled());
    }

    private MetadataInfo(byte[] edmxBytes, boolean cdsToEdm) throws Exception {
        this.edmxBytes = edmxBytes;
        this.provider = MetadataInfo.calculateProvider(edmxBytes, cdsToEdm);
        this.etag = MetadataInfo.calculateMetadataEtag(edmxBytes);
    }

    private static CsdlEdmProvider calculateProvider(byte[] edmxBytes, boolean cdsToEdm) throws Exception {
        if (cdsToEdm || MetadataInfo.isEmpty(edmxBytes)) {
            return null;
        }
        try (ByteArrayInputStream stream = new ByteArrayInputStream(edmxBytes);){
            ODataEdmProvider oDataEdmProvider = new ODataEdmProvider(stream);
            return oDataEdmProvider;
        }
    }

    private static String calculateMetadataEtag(byte[] edmxBytes) {
        if (MetadataInfo.isEmpty(edmxBytes)) {
            return null;
        }
        return Hashing.sha256().hashBytes(edmxBytes).toString();
    }

    private static boolean isEmpty(byte[] edmxBytes) {
        return edmxBytes == null || edmxBytes.length == 0;
    }

    public boolean isEmpty() {
        return MetadataInfo.isEmpty(this.edmxBytes);
    }

    public InputStream getEdmx() {
        return new ByteArrayInputStream(this.edmxBytes);
    }

    public CsdlEdmProvider getEdmProvider() {
        return this.provider;
    }

    public String getETag() {
        return this.etag;
    }
}

