/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata;

import com.sap.cds.adapter.odata.v4.metadata.extension.CustomVocabularyCatalog;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlAliasInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;
import org.apache.olingo.commons.api.ex.ODataException;

public class ODataExtendedEdmProvider
implements CsdlEdmProvider {
    private static final CsdlSchema customSchema = CustomVocabularyCatalog.getHierarchySchema();
    private final CsdlEdmProvider baseProvider;
    private List<CsdlSchema> extendedSchemata = null;

    private ODataExtendedEdmProvider(CsdlEdmProvider baseProvider) {
        this.baseProvider = baseProvider;
    }

    public static ODataExtendedEdmProvider wrap(CsdlEdmProvider baseProvider) {
        return new ODataExtendedEdmProvider(baseProvider);
    }

    public List<CsdlSchema> getSchemas() throws ODataException {
        if (this.extendedSchemata == null) {
            List baseSchemata = this.baseProvider.getSchemas();
            this.extendedSchemata = new ArrayList<CsdlSchema>(baseSchemata.size() + 1);
            this.extendedSchemata.addAll(baseSchemata);
            this.extendedSchemata.add(customSchema);
        }
        return this.extendedSchemata;
    }

    public CsdlEnumType getEnumType(FullQualifiedName enumTypeName) throws ODataException {
        return this.baseProvider.getEnumType(enumTypeName);
    }

    public CsdlTypeDefinition getTypeDefinition(FullQualifiedName typeDefinitionName) throws ODataException {
        return this.baseProvider.getTypeDefinition(typeDefinitionName);
    }

    public CsdlEntityType getEntityType(FullQualifiedName entityTypeName) throws ODataException {
        return this.baseProvider.getEntityType(entityTypeName);
    }

    public CsdlComplexType getComplexType(FullQualifiedName complexTypeName) throws ODataException {
        return this.baseProvider.getComplexType(complexTypeName);
    }

    public List<CsdlAction> getActions(FullQualifiedName actionName) throws ODataException {
        return this.baseProvider.getActions(actionName);
    }

    public List<CsdlFunction> getFunctions(FullQualifiedName functionName) throws ODataException {
        List<CsdlSchema> csdlSchemas = this.getSchemas();
        for (CsdlSchema csdlSchema : csdlSchemas) {
            if (!Objects.equals(csdlSchema.getNamespace(), functionName.getNamespace()) && !Objects.equals(csdlSchema.getAlias(), functionName.getNamespace())) continue;
            return csdlSchema.getFunctions(functionName.getName());
        }
        return null;
    }

    public CsdlTerm getTerm(FullQualifiedName termName) throws ODataException {
        return this.baseProvider.getTerm(termName);
    }

    public CsdlEntitySet getEntitySet(FullQualifiedName entityContainer, String entitySetName) throws ODataException {
        return this.baseProvider.getEntitySet(entityContainer, entitySetName);
    }

    public CsdlSingleton getSingleton(FullQualifiedName entityContainer, String singletonName) throws ODataException {
        return this.baseProvider.getSingleton(entityContainer, singletonName);
    }

    public CsdlActionImport getActionImport(FullQualifiedName entityContainer, String actionImportName) throws ODataException {
        return this.baseProvider.getActionImport(entityContainer, actionImportName);
    }

    public CsdlFunctionImport getFunctionImport(FullQualifiedName entityContainer, String functionImportName) throws ODataException {
        return this.baseProvider.getFunctionImport(entityContainer, functionImportName);
    }

    public CsdlEntityContainerInfo getEntityContainerInfo(FullQualifiedName entityContainerName) throws ODataException {
        return this.baseProvider.getEntityContainerInfo(entityContainerName);
    }

    public List<CsdlAliasInfo> getAliasInfos() throws ODataException {
        return this.baseProvider.getAliasInfos();
    }

    public CsdlEntityContainer getEntityContainer() throws ODataException {
        return this.baseProvider.getEntityContainer();
    }

    public CsdlAnnotations getAnnotationsGroup(FullQualifiedName targetName, String qualifier) throws ODataException {
        return this.baseProvider.getAnnotationsGroup(targetName, qualifier);
    }
}

