/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.processors;

import com.sap.cds.Result;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.CdsProcessor;
import com.sap.cds.adapter.odata.v4.processors.request.CdsODataRequest;
import com.sap.cds.adapter.odata.v4.processors.response.CdsODataResponse;
import com.sap.cds.adapter.odata.v4.processors.response.ResultSetProcessor;
import com.sap.cds.adapter.odata.v4.utils.EdmUtils;
import com.sap.cds.adapter.odata.v4.utils.MessagesUtils;
import com.sap.cds.adapter.odata.v4.utils.ODataUtils;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.server.api.ODataContent;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.prefer.Preferences;
import org.apache.olingo.server.api.prefer.PreferencesApplied;
import org.apache.olingo.server.api.serializer.EdmAssistedSerializer;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriHelper;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;

public abstract class AbstractODataProcessor {
    protected final CdsRequestGlobals globals;
    protected final CdsProcessor cdsProcessor;
    protected final EdmUtils edmUtils;
    protected final boolean isBuffered;

    protected AbstractODataProcessor(CdsRequestGlobals globals) {
        this.globals = globals;
        this.cdsProcessor = new CdsProcessor(globals);
        this.edmUtils = new EdmUtils(globals);
        this.isBuffered = globals.getRuntime().getEnvironment().getCdsProperties().getOdataV4().getSerializer().isBuffered();
    }

    public abstract void processEntity(ODataRequest var1, ODataResponse var2, UriInfo var3, ContentType var4, ContentType var5);

    public abstract void processEntities(ODataRequest var1, ODataResponse var2, UriInfo var3, ContentType var4, ContentType var5);

    public abstract void processSingleComplex(ODataRequest var1, ODataResponse var2, UriInfo var3, ContentType var4, ContentType var5);

    public abstract void processCollectionComplex(ODataRequest var1, ODataResponse var2, UriInfo var3, ContentType var4, ContentType var5);

    public abstract void processSinglePrimitive(ODataRequest var1, ODataResponse var2, UriInfo var3, ContentType var4, ContentType var5);

    public abstract void processSinglePrimitiveValue(ODataRequest var1, ODataResponse var2, UriInfo var3, ContentType var4, ContentType var5);

    public abstract void processCollectionPrimitive(ODataRequest var1, ODataResponse var2, UriInfo var3, ContentType var4, ContentType var5);

    public void processNoContentRequest(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            if (this.isValueRequestOnStreamProperty((CdsODataRequest)cdsRequest)) {
                UriResourcePartTyped lastTypedResource = cdsRequest.getLastTypedResource();
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.VALUE_ACCESS_NOT_ALLOWED, new Object[]{lastTypedResource.getSegmentValue()});
            }
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, (InputStream)null, null);
        });
    }

    public void processCountRequest(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) {
        this.processRequest(odataRequest, odataResponse, uriInfo, null, (cdsRequest, cdsResponse) -> {
            InputStream content;
            int count = ResultSetProcessor.toCount(cdsResponse.getResult());
            try {
                content = this.globals.getOData().createFixedFormatSerializer().count(Integer.valueOf(count));
            }
            catch (SerializerException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
            }
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, content, ContentType.TEXT_PLAIN);
        });
    }

    static void setLocationHeader(ODataResponse odataResponse, String locationPrefix, String id) {
        if (locationPrefix != null) {
            String location = locationPrefix + (id == null ? "" : id);
            odataResponse.setHeader("Location", location);
            odataResponse.setHeader("OData-EntityID", location);
        }
    }

    static void setCacheControlHeader(ODataResponse odataResponse, CdsEntity entity, String property) {
        Object maxAge = ODataUtils.getMaxAgeValue(entity, property);
        if (maxAge != null) {
            odataResponse.setHeader("Cache-Control", "max-age=" + maxAge);
        }
    }

    static void setInlineCount(UriInfo uriInfo, Result result, EntityCollection entityCollection) {
        if (uriInfo.getCountOption() != null && uriInfo.getCountOption().getValue()) {
            int inlineCount = (int)result.inlineCount();
            if (inlineCount == -1) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MISSING_VALUE_FOR_COUNT, new Object[0]);
            }
            entityCollection.setCount(Integer.valueOf(inlineCount));
        }
    }

    protected boolean isValueRequestOnStreamProperty(CdsODataRequest request) {
        UriResource lastResource = request.getLastResource();
        UriResourcePartTyped lastTypedResource = request.getLastTypedResource();
        return lastResource.getKind().equals((Object)UriResourceKind.value) && lastTypedResource.getType() instanceof EdmStream;
    }

    protected void processRequest(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, BiConsumer<CdsODataRequest, CdsODataResponse> processor) {
        CdsODataRequest cdsRequest = new CdsODataRequest(odataRequest, uriInfo, requestFormat, this.globals);
        this.cdsProcessor.processRequest(cdsRequest, cdsResponse -> {
            if (cdsResponse.isSuccess()) {
                processor.accept(cdsRequest, (CdsODataResponse)cdsResponse);
            } else {
                ODataUtils.setODataErrorResponse(this.globals.getOData(), odataRequest, odataResponse, cdsResponse, ODataUtils.getBindingParameter(this.globals.getModel(), uriInfo), ContentType.APPLICATION_JSON);
            }
        });
    }

    protected void setODataResponse(CdsODataRequest cdsRequest, CdsODataResponse cdsResponse, ODataResponse odataResponse, InputStream content, ContentType contentType) {
        this.setODataResponse(cdsRequest, cdsResponse, odataResponse, content, null, contentType);
    }

    protected void setODataResponse(CdsODataRequest cdsRequest, CdsODataResponse cdsResponse, ODataResponse odataResponse, ODataContent content, ContentType contentType) {
        InputStream bufferContent = this.isBuffered ? this.toInputStream(content) : null;
        this.setODataResponse(cdsRequest, cdsResponse, odataResponse, bufferContent, content, contentType);
    }

    protected void setODataResponse(CdsODataRequest cdsRequest, CdsODataResponse cdsResponse, ODataResponse odataResponse, InputStream bufferContent, ODataContent odataContent, ContentType contentType) {
        if ((bufferContent != null || odataContent != null) && contentType != null) {
            odataResponse.setStatusCode(cdsResponse.getStatusCode());
            odataResponse.setHeader("Content-Type", contentType.toContentTypeString());
            if (bufferContent != null) {
                odataResponse.setContent(bufferContent);
            } else {
                odataResponse.setODataContent(odataContent);
            }
        } else {
            odataResponse.setStatusCode(cdsResponse.getStatusCode() < 204 ? 204 : cdsResponse.getStatusCode());
        }
        Preferences.Return returnPreference = cdsRequest.getReturnPreference();
        if (returnPreference != null) {
            String applied = PreferencesApplied.with().returnRepresentation(returnPreference).build().toValueString();
            odataResponse.setHeader("Preference-Applied", applied);
        }
        odataResponse.setHeader("OData-Version", ODataUtils.getODataVersion(cdsRequest.getODataRequest()));
        String sapMessageHeader = MessagesUtils.getSapMessagesHeader(ODataUtils.getBindingParameter(this.globals.getModel(), cdsRequest.getUriInfo()), RequestContext.getCurrent((CdsRuntime)this.globals.getRuntime()).getMessages());
        if (!StringUtils.isEmpty((String)sapMessageHeader)) {
            odataResponse.setHeader("sap-messages", sapMessageHeader);
        }
    }

    private InputStream toInputStream(ODataContent odataContent) {
        if (null != odataContent) {
            CircleStreamBuffer buffer = new CircleStreamBuffer(1024);
            odataContent.write(buffer.getOutputStream());
            return buffer.getInputStream();
        }
        return null;
    }

    protected ODataSerializer createSerializer(ODataRequest odataRequest, ContentType responseFormat) {
        return ODataUtils.createSerializer(this.globals.getOData(), odataRequest, responseFormat);
    }

    protected EdmAssistedSerializer createSerializerForApply(ODataRequest odataRequest, ContentType responseFormat) {
        return ODataUtils.createSerializerForApply(this.globals.getOData(), odataRequest, responseFormat);
    }

    protected boolean isActionOrFunction(CdsODataRequest request) {
        UriResource lastResource = request.getLastResource();
        return lastResource.getKind() == UriResourceKind.action || lastResource.getKind() == UriResourceKind.function;
    }

    protected ContextURL getContextUrl(CdsODataRequest request, boolean isCollection, SelectOption select, ExpandOption expand) {
        try {
            ContextURL.Builder builder = ContextURL.with();
            UriHelper uriHelper = this.globals.getOData().createUriHelper();
            if (this.globals.getRuntime().getEnvironment().getCdsProperties().getOdataV4().isContextAbsoluteUrl()) {
                try {
                    builder.serviceRoot(new URI(request.getODataRequest().getRawBaseUri() + "/"));
                }
                catch (URISyntaxException e) {
                    throw new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[]{e});
                }
            }
            boolean isSingleton = false;
            EdmType responseType = request.getResponseType();
            if (this.isActionOrFunction(request)) {
                if (isCollection) {
                    builder.asCollection();
                }
                builder.type(responseType);
            } else {
                UriResourcePartTyped entityResource = request.getLastEntityResource(false);
                EdmEntityType entityType = (EdmEntityType)entityResource.getType();
                EdmBindingTarget bindingTarget = this.edmUtils.getEdmBindingTarget(entityType);
                List uriResources = request.getUriInfo().getUriResourceParts();
                int entitySetIndex = uriResources.indexOf(entityResource);
                if (entitySetIndex + 1 < uriResources.size()) {
                    Object keys = "";
                    if (entityResource.getKind() == UriResourceKind.entitySet) {
                        keys = "(" + uriHelper.buildContextURLKeyPredicate(((UriResourceEntitySet)entityResource).getKeyPredicates()) + ")";
                    } else if (entityResource.getKind() == UriResourceKind.navigationProperty) {
                        keys = "(" + uriHelper.buildContextURLKeyPredicate(((UriResourceNavigation)entityResource).getKeyPredicates()) + ")";
                    }
                    builder.entitySetOrSingletonOrType(bindingTarget.getName() + (String)keys);
                    StringBuilder navigationPathBuilder = new StringBuilder();
                    UriResourceNavigation previousUriResourceNavigation = null;
                    for (UriResource uriResource : uriResources.subList(entitySetIndex + 1, uriResources.size())) {
                        String navKeys;
                        if (previousUriResourceNavigation != null && !previousUriResourceNavigation.isCollection() && (navKeys = uriHelper.buildContextURLKeyPredicate(previousUriResourceNavigation.getKeyPredicates())) != null) {
                            navigationPathBuilder.append("(").append(navKeys).append(")");
                        }
                        if (navigationPathBuilder.length() > 0) {
                            navigationPathBuilder.append("/");
                        }
                        if (uriResource.getKind() == UriResourceKind.navigationProperty) {
                            UriResourceNavigation uriResourceNavigation = (UriResourceNavigation)uriResource;
                            navigationPathBuilder.append(uriResourceNavigation.getProperty().getName());
                            previousUriResourceNavigation = uriResourceNavigation;
                            continue;
                        }
                        if (uriResource.getKind() == UriResourceKind.complexProperty) {
                            navigationPathBuilder.append(((UriResourceComplexProperty)uriResource).getProperty().getName());
                            continue;
                        }
                        if (uriResource.getKind() == UriResourceKind.primitiveProperty) {
                            navigationPathBuilder.append(((UriResourcePrimitiveProperty)uriResource).getProperty().getName());
                            continue;
                        }
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{uriResource.getKind()});
                    }
                    builder.navOrPropertyPath(navigationPathBuilder.toString());
                } else if (responseType.getKind() == EdmTypeKind.ENTITY) {
                    isSingleton = bindingTarget instanceof EdmSingleton;
                    builder.entitySetOrSingletonOrType(bindingTarget.getName());
                } else {
                    if (isCollection) {
                        builder.asCollection();
                    }
                    builder.type(responseType);
                }
                if (responseType.getKind() == EdmTypeKind.ENTITY && !isCollection && !isSingleton) {
                    builder.suffix(ContextURL.Suffix.ENTITY);
                }
            }
            if ((expand != null || select != null) && responseType instanceof EdmStructuredType) {
                EdmStructuredType type = (EdmStructuredType)responseType;
                String selectList = uriHelper.buildContextURLSelectList(type, expand, select);
                builder.selectList(selectList);
            }
            return builder.build();
        }
        catch (SerializerException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
        }
    }

    protected void checkCountOptionsOnExpand(Entity entity, ExpandOption expandOption) {
        if (expandOption != null) {
            expandOption.getExpandItems().forEach(expandItem -> {
                if (expandItem.getCountOption() != null && expandItem.getCountOption().getValue()) {
                    EntityCollection inlineEntityCollection;
                    String expandedItemName = !expandItem.getResourcePath().getUriResourceParts().isEmpty() ? ((UriResource)expandItem.getResourcePath().getUriResourceParts().get(0)).getSegmentValue() : "";
                    EntityCollection entityCollection = inlineEntityCollection = entity.getNavigationLink(expandedItemName) != null ? entity.getNavigationLink(expandedItemName).getInlineEntitySet() : null;
                    if (inlineEntityCollection != null) {
                        inlineEntityCollection.setCount(Integer.valueOf(inlineEntityCollection.getEntities().size()));
                        if (expandItem.getExpandOption() != null) {
                            inlineEntityCollection.getEntities().forEach(inlineEntity -> this.checkCountOptionsOnExpand((Entity)inlineEntity, expandItem.getExpandOption()));
                        }
                    }
                }
            });
        }
    }

    protected Optional<EdmProperty> getEdmProperty(CdsODataRequest cdsRequest) {
        return Optional.ofNullable(cdsRequest.getLastTypedResource()).filter(UriResourcePrimitiveProperty.class::isInstance).map(UriResourcePrimitiveProperty.class::cast).map(UriResourceProperty::getProperty);
    }

    protected boolean isGetStreamContext(ODataRequest odataRequest, UriInfo uriInfo, ContentType requestFormat) {
        HttpMethod method = odataRequest.getMethod();
        CdsODataRequest cdsODataRequest = new CdsODataRequest(odataRequest, uriInfo, requestFormat, this.globals);
        return method.equals((Object)HttpMethod.GET) && cdsODataRequest.getLastTypedResource().getType() instanceof EdmStream;
    }

    protected void setContentDispositionHeaderIfNotNull(ODataResponse response, String filename) {
        if (!StringUtils.isEmpty((String)filename)) {
            response.setHeader("Content-Disposition", "attachment; filename=\"%s\"".formatted(filename));
        }
    }
}

