/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.adapter.odata.v4.query.apply.ApplyHandler;
import com.sap.cds.adapter.odata.v4.query.apply.OrderByTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.SearchTransformation;
import com.sap.cds.adapter.odata.v4.utils.ETagHelper;
import com.sap.cds.adapter.odata.v4.utils.ElementUtils;
import com.sap.cds.adapter.odata.v4.utils.StreamUtils;
import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStar;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.transformations.TransformationToSelect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;

public class SystemQueryLoader {
    private final EdmxFlavourMapper elementMapper;
    private final EdmxFlavourMapper.EdmxFlavour flavour;
    private final boolean transformationsInCqn;

    private SystemQueryLoader(EdmxFlavourMapper elementMapper, EdmxFlavourMapper.EdmxFlavour flavour, boolean transformationsInCqn) {
        this.elementMapper = elementMapper;
        this.flavour = flavour;
        this.transformationsInCqn = transformationsInCqn;
    }

    public static SystemQueryLoader create(EdmxFlavourMapper elementMapper, EdmxFlavourMapper.EdmxFlavour flavour) {
        return new SystemQueryLoader(elementMapper, flavour, false);
    }

    public static SystemQueryLoader create(EdmxFlavourMapper elementMapper, EdmxFlavourMapper.EdmxFlavour flavour, boolean transformationsInCqn) {
        return new SystemQueryLoader(elementMapper, flavour, transformationsInCqn);
    }

    public List<Select<?>> updateSelectQuery(Select<?> select, UriInfo uriInfo, CdsEntity entity) {
        List<Select<?>> selects;
        ApplyOption apply = uriInfo.getApplyOption();
        if (apply == null) {
            select.columns(this.unfold((CdsStructuredType)entity, (CqnSelectListItem)CqnStar.star()));
            this.addSystemQueryOptions(select, uriInfo, entity);
            selects = List.of(select);
        } else {
            ApplyHandler applyHandler = ApplyHandler.create(apply, new ExpressionParser((CdsStructuredType)entity, this.elementMapper));
            if (applyHandler.hasConcat()) {
                this.rejectOtherSystemQueryOptions(uriInfo);
            }
            List<Select<?>> unfolded = applyHandler.transform(select);
            selects = new ArrayList(unfolded.size());
            for (Select<?> s : unfolded) {
                this.addSystemQueryOptions(s, uriInfo, entity);
                TransformationToSelect transformer = new TransformationToSelect(s);
                if (this.transformationsInCqn) {
                    transformer.applyOrderAndLimit();
                } else {
                    transformer.applyTransformations();
                }
                selects.add(transformer.get());
            }
        }
        return selects;
    }

    private void rejectOtherSystemQueryOptions(UriInfo uriInfo) {
        uriInfo.getSystemQueryOptions().stream().map(SystemQueryOption::getKind).filter(k -> k != SystemQueryOptionKind.APPLY && k != SystemQueryOptionKind.FORMAT).findAny().ifPresent(k -> {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_CONCAT_SYSTEMQUERY, new Object[]{k.toString()});
        });
    }

    private void addSystemQueryOptions(Select<?> select, UriInfo uriInfo, CdsEntity entity) {
        ExpressionParser expressionParser = new ExpressionParser((CdsStructuredType)entity, this.elementMapper);
        if (uriInfo.getOrderByOption() != null) {
            OrderByTransformation transformation = new OrderByTransformation(uriInfo.getOrderByOption(), expressionParser);
            select.orderBy(transformation.orderBy());
        }
        if (uriInfo.getFilterOption() != null) {
            select.where(expressionParser.parseFilter(uriInfo.getFilterOption().getExpression()));
        }
        if (uriInfo.getSearchOption() != null) {
            select.search((CqnPredicate)SearchTransformation.convertSearchOption(uriInfo.getSearchOption()));
        }
        if (uriInfo.getCountOption() != null && uriInfo.getCountOption().getValue()) {
            select.inlineCount();
        }
    }

    public Select<?> updateSelectColumns(Select<?> select, UriInfo uriInfo, CdsEntity entity) {
        if (uriInfo.getSelectOption() != null) {
            Stream<CqnSelectListValue> items = select.items().stream().flatMap(sli -> this.unfold((CdsStructuredType)entity, (CqnSelectListItem)sli));
            select.columns(SystemQueryLoader.reduce(items, this.getSelectColumns(uriInfo.getSelectOption(), entity)));
        }
        if (uriInfo.getExpandOption() != null) {
            select.columns(SystemQueryLoader.merge(select.items(), this.getExpandColumns(uriInfo.getExpandOption(), entity)));
        }
        return select;
    }

    public Select<?> updateSelect(Select<?> select, UriInfo uriInfo, CdsEntity entity) {
        select = this.updateSelectQuery(select, uriInfo, entity).get(0);
        return this.updateSelectColumns(select, uriInfo, entity);
    }

    private List<String> getSelectColumns(SelectOption selectOption, CdsEntity entity) {
        HashSet<String> items = new HashSet<String>();
        entity.keyElements().map(key -> key.getName()).forEach(items::add);
        String etagElement = ETagHelper.getETagElementName(entity);
        if (etagElement != null) {
            items.add(etagElement);
        }
        for (SelectItem selectItem : selectOption.getSelectItems()) {
            if (selectItem.isStar()) {
                items.clear();
                ElementUtils.recursiveElements((CdsStructuredType)entity).keySet().forEach(items::add);
                break;
            }
            if (selectItem.getResourcePath() == null) continue;
            List uriResourceParts = selectItem.getResourcePath().getUriResourceParts();
            if (uriResourceParts.size() > 1) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SELECT_PARSING_FAILED, new Object[0]);
            }
            String element = this.elementMapper.remap(((UriResource)uriResourceParts.get(0)).getSegmentValue(), (CdsStructuredType)entity);
            items.add(element);
            String mediaTypeElement = StreamUtils.getCoreMediaTypeElement(entity, element);
            if (StringUtils.isEmpty((CharSequence)mediaTypeElement)) continue;
            items.add(mediaTypeElement);
        }
        return new ArrayList<String>(items);
    }

    private List<CqnSelectListItem> getExpandColumns(ExpandOption expandOption, CdsEntity entity) {
        List expandItems = expandOption.getExpandItems();
        if (expandItems.size() == 1 && ((ExpandItem)expandItems.get(0)).isStar()) {
            return Collections.singletonList(CQL.to((String)"*").expand());
        }
        ArrayList<CqnSelectListItem> expands = new ArrayList<CqnSelectListItem>();
        for (ExpandItem expandItem : expandItems) {
            if (expandItem.isStar()) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_EXPAND_STAR, new Object[0]);
            }
            for (UriResource uriResource : expandItem.getResourcePath().getUriResourceParts()) {
                if (!(uriResource instanceof UriResourceNavigation)) continue;
                String associationName = this.elementMapper.remap(uriResource.getSegmentValue(), (CdsStructuredType)entity);
                StructuredType<?> type = ElementUtils.aliasedTo(associationName);
                CdsEntity navigationEntity = (CdsEntity)entity.getTargetOf(associationName);
                ExpressionParser expressionParser = new ExpressionParser((CdsStructuredType)navigationEntity, this.elementMapper);
                List<CqnSelectListItem> items = navigationEntity.nonAssociationElements().map(e -> CQL.get((String)e.getName())).collect(Collectors.toList());
                if (expandItem.getSelectOption() != null) {
                    Stream<CqnSelectListValue> slvs = items.stream().flatMap(sli -> this.unfold((CdsStructuredType)navigationEntity, (CqnSelectListItem)sli));
                    items = SystemQueryLoader.reduce(slvs, this.getSelectColumns(expandItem.getSelectOption(), navigationEntity));
                }
                if (expandItem.getFilterOption() != null) {
                    type.filter(expressionParser.parseFilter(expandItem.getFilterOption().getExpression()));
                }
                if (expandItem.getExpandOption() != null) {
                    items = SystemQueryLoader.merge(items, this.getExpandColumns(expandItem.getExpandOption(), navigationEntity));
                }
                Expand expand = type.expand(items);
                if (expandItem.getOrderByOption() != null) {
                    OrderByTransformation transformation = new OrderByTransformation(expandItem.getOrderByOption(), expressionParser);
                    expand.orderBy(transformation.orderBy());
                }
                int top = Integer.MAX_VALUE;
                int skip = 0;
                if (expandItem.getTopOption() != null) {
                    top = expandItem.getTopOption().getValue();
                }
                if (expandItem.getSkipOption() != null) {
                    skip = expandItem.getSkipOption().getValue();
                }
                if (top < Integer.MAX_VALUE || skip > 0) {
                    expand.limit((long)top, (long)skip);
                }
                SystemQueryLoader.applyInlineCount(entity, expandItem, associationName, expand);
                expands.add((CqnSelectListItem)expand);
            }
        }
        return expands;
    }

    private static void applyInlineCount(CdsEntity entity, ExpandItem expandItem, String associationName, Expand<?> expand) {
        if (expandItem.hasCountPath() || expandItem.getCountOption() != null) {
            if (CdsModelUtils.isSingleValued((CdsType)entity.getAssociation(associationName).getType())) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INLINE_COUNT_ON_TO_ONE_ASSOC, new Object[]{associationName});
            }
            if (expandItem.hasCountPath()) {
                expand.limit(0L).inlineCount();
            } else if (expandItem.getCountOption() != null && expandItem.getCountOption().getValue()) {
                expand.inlineCount();
            }
        }
    }

    private static List<CqnSelectListItem> reduce(Stream<CqnSelectListValue> slvs, List<String> allowedColumns) {
        return slvs.filter(slv -> allowedColumns.stream().anyMatch(c -> c.equals(slv.displayName()) || c.startsWith(slv.displayName() + "."))).collect(Collectors.toList());
    }

    private static List<CqnSelectListItem> merge(List<CqnSelectListItem> columns, List<CqnSelectListItem> additionalColumns) {
        if (additionalColumns.isEmpty()) {
            return columns;
        }
        ArrayList<CqnSelectListItem> items = new ArrayList<CqnSelectListItem>(columns);
        for (CqnSelectListItem newItem : additionalColumns) {
            List<? extends CqnReference.Segment> newSegments = SystemQueryLoader.getSegments(newItem.token());
            items.stream().filter(c -> SystemQueryLoader.isMatching(c, newSegments)).findFirst().ifPresent(items::remove);
            items.add(newItem);
        }
        return items;
    }

    private Stream<CqnSelectListValue> unfold(CdsStructuredType type, CqnSelectListItem sli) {
        if (sli.isValue()) {
            return Stream.of(sli.asValue());
        }
        if (sli.isStar()) {
            Stream<CqnSelectListValue> elements = ElementUtils.recursiveElements(type, e -> !e.getType().isAssociation()).keySet().stream().map(e -> ElementUtils.aliasedGet(e));
            if (this.flavour == EdmxFlavourMapper.EdmxFlavour.V4) {
                Stream<CqnSelectListValue> associations = ElementUtils.recursiveElements(type, e -> e.getType().isAssociation() && CdsModelUtils.managedToOne((CdsType)e.getType())).keySet().stream().map(e -> ElementUtils.aliasedGet(e));
                elements = Stream.concat(elements, associations);
            }
            return elements;
        }
        return Stream.empty();
    }

    private static boolean isMatching(CqnSelectListItem c, List<? extends CqnReference.Segment> newSegments) {
        List<? extends CqnReference.Segment> segments = SystemQueryLoader.getSegments(c.token());
        if (segments == null || newSegments == null || segments.size() != newSegments.size()) {
            return false;
        }
        for (int i = 0; i < segments.size(); ++i) {
            CqnReference.Segment segment = segments.get(i);
            CqnReference.Segment newSegment = newSegments.get(i);
            if (!segment.id().equals(newSegment.id())) {
                return false;
            }
            if (!(segment.filter().isPresent() ? !segment.toJson().equals(newSegment.toJson()) : newSegment.filter().isPresent())) continue;
            return false;
        }
        return true;
    }

    private static List<? extends CqnReference.Segment> getSegments(CqnToken token) {
        CqnSelectListValue listValue;
        CqnValue value;
        if (token instanceof CqnReference) {
            CqnReference reference = (CqnReference)token;
            return reference.segments();
        }
        if (token instanceof Expand) {
            Expand expand = (Expand)token;
            return expand.ref().segments();
        }
        if (token instanceof CqnSelectListValue && (value = (listValue = (CqnSelectListValue)token).value()).isRef()) {
            return value.asRef().segments();
        }
        return null;
    }
}

