/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.ql.cqn.CqnSelect;

public class LimitCalculator {
    private long skip;
    private long top;

    private LimitCalculator(long top, long skip) {
        this.skip = skip;
        this.top = top;
    }

    public static LimitCalculator of(CqnSelect select) {
        return select.hasLimit() ? LimitCalculator.of(select.top(), select.skip()) : LimitCalculator.initial();
    }

    public static LimitCalculator initial() {
        return new LimitCalculator(Integer.MAX_VALUE, 0L);
    }

    public LimitCalculator top(long rows) {
        if (rows < this.top) {
            this.top = rows;
        }
        return this;
    }

    public LimitCalculator skip(long rows) {
        this.skip += rows;
        this.top -= rows;
        return this;
    }

    public long top() {
        return this.top;
    }

    public long skip() {
        return this.skip;
    }

    public static LimitCalculator of(long top, long skip) {
        return new LimitCalculator(top, skip);
    }
}

