/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.DataValue;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.AbstractPrimitiveData2Json;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;

public class BooleanArray2Json<T>
extends AbstractPrimitiveData2Json<T, List<Boolean>> {
    private final String name;

    private BooleanArray2Json(String name, Function<T, DataValue<List<Boolean>>> valueFunc) {
        super(valueFunc);
        this.name = name;
    }

    public static <T> BooleanArray2Json<T> val(String name, Function<T, DataValue<List<Boolean>>> valueFunc) {
        return new BooleanArray2Json<T>(name, valueFunc);
    }

    @Override
    protected void write(List<Boolean> val, JsonGenerator json) throws IOException {
        json.writeFieldName(this.name);
        json.writeStartArray();
        if (val != null) {
            for (Boolean v : val) {
                if (v != null) {
                    json.writeBoolean(v.booleanValue());
                    continue;
                }
                json.writeNull();
            }
        }
        json.writeEndArray();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

