/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.DataValue;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.AbstractPrimitiveData2Json;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.function.Function;

public class Stream2Json<T>
extends AbstractPrimitiveData2Json<T, Closeable> {
    private final String name;

    private Stream2Json(String name, Function<T, DataValue<Closeable>> valueFunc) {
        super(valueFunc);
        this.name = name;
    }

    public static <T> Stream2Json<T> val(String name, Function<T, DataValue<Closeable>> valueFunc) {
        return new Stream2Json<T>(name, valueFunc);
    }

    @Override
    protected void write(Closeable stream, JsonGenerator json) throws IOException {
        json.writeFieldName(this.name);
        if (null == stream) {
            json.writeNull();
        } else if (stream instanceof Reader) {
            Reader reader = (Reader)stream;
            json.writeString(reader, -1);
        } else if (stream instanceof InputStream) {
            InputStream inputStream = (InputStream)stream;
            json.writeBinary(inputStream, -1);
        } else {
            throw new IllegalArgumentException("Stream of type '%s' not supported".formatted(stream.getClass().getName()));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

