/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.cds;

import com.sap.cds.adapter.odata.v4.metadata.cds.CdsServiceEdmUtils;
import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper;
import com.sap.cds.impl.AssociationAnalyzer;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsBoundAction;
import com.sap.cds.reflect.CdsBoundFunction;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsOperation;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlNamed;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;
import org.apache.olingo.commons.api.edm.provider.CsdlReturnType;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;

class CdsServiceEdmSchema
extends CsdlSchema {
    private final CdsService service;
    private final EdmxFlavourMapper edmxFlavourMapper;
    private final Map<String, CdsEntityInfo> entityLookup = new HashMap<String, CdsEntityInfo>();
    private final Map<String, List<CdsOperationInfo<CdsAction>>> actionLookup = new HashMap<String, List<CdsOperationInfo<CdsAction>>>();
    private final Map<String, List<CdsOperationInfo<CdsFunction>>> functionLookup = new HashMap<String, List<CdsOperationInfo<CdsFunction>>>();
    private final Map<String, CdsStructuredType> complexTypeLookup = new HashMap<String, CdsStructuredType>();
    private final Map<CdsDefinition, CsdlNamed> cached = new HashMap<CdsDefinition, CsdlNamed>();

    CdsServiceEdmSchema(CdsService service, CsdlEntityContainer entityContainer, EdmxFlavourMapper edmxFlavourMapper) {
        this.service = service;
        this.edmxFlavourMapper = edmxFlavourMapper;
        service.entities().filter(CdsServiceEdmUtils::isIncluded).forEach(e -> {
            if (CdsServiceEdmUtils.isParameterized(e)) {
                this.entityLookup.put(CdsServiceEdmUtils.name((CdsDefinition)e) + "Parameters", new CdsEntityInfo((CdsEntity)e, EntityTypeKind.PARAMETERIZED_PARAMETERS));
                this.entityLookup.put(CdsServiceEdmUtils.name((CdsDefinition)e) + "Type", new CdsEntityInfo((CdsEntity)e, EntityTypeKind.PARAMETERIZED_TYPE));
            } else {
                this.entityLookup.put(CdsServiceEdmUtils.name((CdsDefinition)e), new CdsEntityInfo((CdsEntity)e, EntityTypeKind.DEFAULT));
            }
            e.actions().forEach(a -> this.actionLookup.compute(CdsServiceEdmUtils.name((CdsDefinition)a), (k, v) -> CdsServiceEdmSchema.addOrInit(v, new CdsOperationInfo<CdsAction>((CdsAction)a, (CdsEntity)e))));
            e.functions().forEach(f -> this.functionLookup.compute(CdsServiceEdmUtils.name((CdsDefinition)f), (k, v) -> CdsServiceEdmSchema.addOrInit(v, new CdsOperationInfo<CdsFunction>((CdsFunction)f, (CdsEntity)e))));
        });
        service.actions().forEach(a -> this.actionLookup.compute(CdsServiceEdmUtils.name((CdsDefinition)a), (k, v) -> CdsServiceEdmSchema.addOrInit(v, new CdsOperationInfo<CdsAction>((CdsAction)a, null))));
        service.functions().forEach(f -> this.functionLookup.compute(CdsServiceEdmUtils.name((CdsDefinition)f), (k, v) -> CdsServiceEdmSchema.addOrInit(v, new CdsOperationInfo<CdsFunction>((CdsFunction)f, null))));
        this.setNamespace(service.getQualifiedName());
        this.setEntityContainer(entityContainer);
        this.setEntityTypes(null);
        this.setComplexTypes(null);
        this.setActions(null);
        this.setFunctions(null);
    }

    public CsdlEntityType getEntityType(String name) {
        CdsEntityInfo info = this.entityLookup.get(name);
        if (info != null) {
            return this.buildEntityType(info);
        }
        return null;
    }

    public List<CsdlEntityType> getEntityTypes() {
        return this.entityLookup.values().stream().map(this::buildEntityType).toList();
    }

    private CsdlEntityType buildEntityType(CdsEntityInfo info) {
        CdsEntity entity = info.entity();
        EntityTypeKind kind = info.kind();
        Function<CdsDefinition, CsdlNamed> builder = e -> {
            CsdlEntityType entityType = new CsdlEntityType();
            entityType.setKey(new ArrayList());
            if (kind == EntityTypeKind.DEFAULT || kind == EntityTypeKind.PARAMETERIZED_TYPE) {
                entityType.setName(CdsServiceEdmUtils.name((CdsDefinition)entity) + (kind == EntityTypeKind.PARAMETERIZED_TYPE ? "Type" : ""));
                entityType.setOpenType(((Boolean)entity.getAnnotationValue("open", (Object)false)).booleanValue());
                entity.keyElements().flatMap(CdsServiceEdmSchema::resolveKeys).forEach(key -> entityType.getKey().add(new CsdlPropertyRef().setName(key)));
                this.edmxFlavourMapper.createMappings((CdsStructuredType)entity).forEach(mapped -> {
                    if (mapped.getMappedElement().getType().isAssociation()) {
                        entityType.getNavigationProperties().add(this.createNavigationProperty(mapped.getEdmxName(), mapped.getMappedElement(), (CdsStructuredType)entity));
                    } else if (CdsServiceEdmUtils.isIncluded(mapped.getMappedElement())) {
                        entityType.getProperties().add(this.createProperty(mapped.getEdmxName(), mapped.getMappedElement(), entityType.getName()));
                    }
                });
                if (kind == EntityTypeKind.PARAMETERIZED_TYPE) {
                    CsdlNavigationProperty parametersNavigation = new CsdlNavigationProperty();
                    parametersNavigation.setName("Parameters");
                    parametersNavigation.setType(CdsServiceEdmUtils.fqn((CdsDefinition)entity) + "Parameters");
                    entityType.getNavigationProperties().add(parametersNavigation);
                }
            } else {
                entityType.setName(CdsServiceEdmUtils.name((CdsDefinition)entity) + "Parameters");
                entity.params().forEach(parameter -> {
                    entityType.getKey().add(new CsdlPropertyRef().setName(parameter.getName()));
                    CsdlProperty property = new CsdlProperty();
                    property.setName(parameter.getName());
                    property.setType(this.type(parameter.getType(), (CdsAnnotatable)parameter, CdsServiceEdmUtils::name));
                    property.setCollection(parameter.getType().isArrayed());
                    property.setNullable(!parameter.isNotNull() && !property.isCollection());
                    if (parameter.getType().isSimple()) {
                        SimpleTypeProperties properties = CdsServiceEdmSchema.simpleTypeProperties((CdsSimpleType)parameter.getType().as(CdsSimpleType.class), (CdsAnnotatable)parameter);
                        property.setMaxLength(properties.maxLength());
                        property.setPrecision(properties.precision());
                        property.setScale(properties.scale());
                        property.setScaleAsString(properties.scaleAsString());
                        property.setSrid(properties.srid());
                    }
                    entityType.getProperties().add(property);
                });
                CsdlNavigationProperty parametersNavigation = new CsdlNavigationProperty();
                parametersNavigation.setName("Set");
                parametersNavigation.setType(CdsServiceEdmUtils.fqn((CdsDefinition)entity) + "Type");
                parametersNavigation.setCollection(true);
                parametersNavigation.setContainsTarget(true);
                entityType.getNavigationProperties().add(parametersNavigation);
            }
            return entityType;
        };
        if (kind == EntityTypeKind.DEFAULT) {
            return (CsdlEntityType)this.cached.computeIfAbsent((CdsDefinition)entity, builder);
        }
        return (CsdlEntityType)builder.apply((CdsDefinition)entity);
    }

    public CsdlComplexType getComplexType(String name) {
        CdsStructuredType structuredType = this.complexTypeLookup.get(name);
        if (structuredType != null) {
            return this.buildComplexType(name, structuredType);
        }
        return null;
    }

    public List<CsdlComplexType> getComplexTypes() {
        List<CsdlComplexType> complexTypes;
        int previousSize;
        this.getEntityTypes();
        this.getActions();
        this.getFunctions();
        do {
            previousSize = this.complexTypeLookup.size();
            complexTypes = new HashSet<Map.Entry<String, CdsStructuredType>>(this.complexTypeLookup.entrySet()).stream().map(e -> this.buildComplexType((String)e.getKey(), (CdsStructuredType)e.getValue())).toList();
        } while (previousSize != this.complexTypeLookup.size());
        return complexTypes;
    }

    private CsdlComplexType buildComplexType(String name, CdsStructuredType type) {
        return (CsdlComplexType)this.cached.computeIfAbsent((CdsDefinition)type, s -> {
            CsdlComplexType complexType = new CsdlComplexType();
            complexType.setName(name);
            complexType.setOpenType(((Boolean)type.getAnnotationValue("open", (Object)false)).booleanValue());
            this.edmxFlavourMapper.createMappings(type).forEach(mapped -> {
                if (mapped.getMappedElement().getType().isAssociation()) {
                    complexType.getNavigationProperties().add(this.createNavigationProperty(mapped.getEdmxName(), mapped.getMappedElement(), type));
                } else if (CdsServiceEdmUtils.isIncluded(mapped.getMappedElement())) {
                    complexType.getProperties().add(this.createProperty(mapped.getEdmxName(), mapped.getMappedElement(), complexType.getName()));
                }
            });
            return complexType;
        });
    }

    private CsdlProperty createProperty(String mappedName, CdsElement element, String parentName) {
        CsdlProperty property = new CsdlProperty();
        property.setName(mappedName);
        property.setType(this.type(element.getType(), (CdsAnnotatable)element, def -> CdsServiceEdmUtils.nameElement((CdsDefinition)def, parentName, mappedName)));
        property.setCollection(element.getType().isArrayed());
        property.setNullable(!element.isNotNull() && !property.isCollection());
        if (element.getType().isSimple()) {
            SimpleTypeProperties properties = CdsServiceEdmSchema.simpleTypeProperties((CdsSimpleType)element.getType().as(CdsSimpleType.class), (CdsAnnotatable)element);
            property.setMaxLength(properties.maxLength());
            property.setPrecision(properties.precision());
            property.setScale(properties.scale());
            property.setScaleAsString(properties.scaleAsString());
            property.setSrid(properties.srid());
        }
        return property;
    }

    private CsdlNavigationProperty createNavigationProperty(String mappedName, CdsElement assoc, CdsStructuredType declarator) {
        CdsEntity target = CdsServiceEdmUtils.target(declarator, assoc);
        CsdlNavigationProperty navProperty = new CsdlNavigationProperty();
        navProperty.setName(mappedName);
        navProperty.setType(CdsServiceEdmUtils.fqn((CdsDefinition)target) + (CdsServiceEdmUtils.isParameterized(target) ? "Parameters" : ""));
        navProperty.setCollection(CdsModelUtils.isToMany((CdsType)assoc.getType()));
        navProperty.setNullable(Boolean.valueOf(!assoc.isNotNull()));
        navProperty.setContainsTarget(((Boolean)declarator.getAnnotationValue("odata.contained", (Object)(DraftUtils.isDraftEnabled((CdsAnnotatable)declarator) && assoc.getName().equals("DraftAdministrativeData") ? 1 : 0))).booleanValue());
        return navProperty;
    }

    public List<CsdlAction> getActions(String name) {
        List<CdsOperationInfo<CdsAction>> actions = this.actionLookup.get(name);
        if (actions != null) {
            return actions.stream().map(this::buildAction).toList();
        }
        return Collections.emptyList();
    }

    public List<CsdlAction> getActions() {
        return this.actionLookup.values().stream().flatMap(Collection::stream).map(this::buildAction).toList();
    }

    private CsdlAction buildAction(CdsOperationInfo<CdsAction> info) {
        CdsAction action = info.operation();
        return (CsdlAction)this.cached.computeIfAbsent((CdsDefinition)action, a -> {
            CsdlAction csdlAction = new CsdlAction();
            csdlAction.setName(CdsServiceEdmUtils.name((CdsDefinition)action));
            if (action instanceof CdsBoundAction) {
                CdsBoundAction boundAction = (CdsBoundAction)action;
                csdlAction.setBound(true);
                csdlAction.getParameters().add(this.createBindingParameter(boundAction.getBindingParameter(), (CdsOperation)action, info.boundTo()));
            }
            action.parameters().forEach(parameter -> csdlAction.getParameters().add(this.createParameter((CdsParameter)parameter, (CdsOperation)action)));
            action.returnType().ifPresent(type -> csdlAction.setReturnType(this.createReturnType((CdsType)type, (CdsOperation)action)));
            return csdlAction;
        });
    }

    public List<CsdlFunction> getFunctions(String name) {
        List<CdsOperationInfo<CdsFunction>> functions = this.functionLookup.get(name);
        if (functions != null) {
            return functions.stream().map(this::buildFunction).toList();
        }
        return Collections.emptyList();
    }

    public List<CsdlFunction> getFunctions() {
        return this.functionLookup.values().stream().flatMap(Collection::stream).map(this::buildFunction).toList();
    }

    private CsdlFunction buildFunction(CdsOperationInfo<CdsFunction> info) {
        CdsFunction function = info.operation();
        return (CsdlFunction)this.cached.computeIfAbsent((CdsDefinition)function, f -> {
            CsdlFunction csdlFunction = new CsdlFunction();
            csdlFunction.setName(CdsServiceEdmUtils.name((CdsDefinition)function));
            if (function instanceof CdsBoundFunction) {
                CdsBoundFunction boundFunction = (CdsBoundFunction)function;
                csdlFunction.setBound(true);
                csdlFunction.getParameters().add(this.createBindingParameter(boundFunction.getBindingParameter(), (CdsOperation)function, info.boundTo()));
            }
            function.parameters().forEach(parameter -> csdlFunction.getParameters().add(this.createParameter((CdsParameter)parameter, (CdsOperation)function)));
            csdlFunction.setReturnType(this.createReturnType(function.getReturnType(), (CdsOperation)function));
            return csdlFunction;
        });
    }

    private CsdlParameter createBindingParameter(CdsParameter bindingParameter, CdsOperation operation, CdsEntity boundTo) {
        boolean notNull;
        boolean isCollection;
        String bindingParameterName;
        if (bindingParameter != null) {
            bindingParameterName = bindingParameter.getName();
            isCollection = bindingParameter.getType().isArrayed();
            notNull = bindingParameter.isNotNull();
        } else {
            bindingParameterName = (String)operation.getAnnotationValue("cds.odata.bindingparameter.name", (Object)"in");
            isCollection = (Boolean)operation.getAnnotationValue("cds.odata.bindingparameter.collection", (Object)false);
            notNull = false;
        }
        CsdlParameter csdlBindingParameter = new CsdlParameter();
        csdlBindingParameter.setName(bindingParameterName);
        csdlBindingParameter.setType(CdsServiceEdmUtils.fqn((CdsDefinition)boundTo) + (CdsServiceEdmUtils.isParameterized(boundTo) ? "Type" : ""));
        csdlBindingParameter.setCollection(isCollection);
        csdlBindingParameter.setNullable(!notNull && !csdlBindingParameter.isCollection());
        return csdlBindingParameter;
    }

    private CsdlParameter createParameter(CdsParameter parameter, CdsOperation operation) {
        CsdlParameter csdlParameter = new CsdlParameter();
        csdlParameter.setName(parameter.getName());
        csdlParameter.setType(this.type(parameter.getType(), (CdsAnnotatable)parameter, def -> CdsServiceEdmUtils.nameParameter((CdsDefinition)def, operation, parameter)));
        csdlParameter.setCollection(parameter.getType().isArrayed());
        csdlParameter.setNullable(!parameter.isNotNull() && !csdlParameter.isCollection());
        if (parameter.getType().isSimple()) {
            SimpleTypeProperties properties = CdsServiceEdmSchema.simpleTypeProperties((CdsSimpleType)parameter.getType().as(CdsSimpleType.class), (CdsAnnotatable)parameter);
            csdlParameter.setMaxLength(properties.maxLength());
            csdlParameter.setPrecision(properties.precision());
            csdlParameter.setScale(properties.scale());
            csdlParameter.setSrid(properties.srid());
        }
        return csdlParameter;
    }

    private CsdlReturnType createReturnType(CdsType type, CdsOperation operation) {
        CsdlReturnType returnType = new CsdlReturnType();
        returnType.setType(this.type(type, (CdsAnnotatable)type, def -> CdsServiceEdmUtils.nameReturn((CdsDefinition)def, operation)));
        returnType.setCollection(type.isArrayed());
        returnType.setNullable(!returnType.isCollection());
        if (type.isSimple()) {
            SimpleTypeProperties properties = CdsServiceEdmSchema.simpleTypeProperties((CdsSimpleType)type.as(CdsSimpleType.class), (CdsAnnotatable)type);
            returnType.setMaxLength(properties.maxLength());
            returnType.setPrecision(properties.precision());
            returnType.setScale(properties.scale());
            returnType.setSrid(properties.srid());
        }
        return returnType;
    }

    private FullQualifiedName type(CdsType type, CdsAnnotatable declarator, Function<CdsStructuredType, String> anonymousNameSupplier) {
        if (type.isStructured()) {
            CdsStructuredType structuredType = (CdsStructuredType)type.as(CdsStructuredType.class);
            FullQualifiedName fqn = CdsServiceEdmUtils.structuredTypeFqn(this.service, structuredType, anonymousNameSupplier);
            if (type.getKind() != CdsKind.ENTITY) {
                this.complexTypeLookup.put(fqn.getName(), structuredType);
            }
            return fqn;
        }
        if (type.isArrayed()) {
            return this.type(((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType(), declarator, anonymousNameSupplier);
        }
        if (type.isSimple()) {
            String edmType = declarator != null && declarator.findAnnotation("odata.Type").isPresent() ? (String)declarator.getAnnotationValue("odata.Type", null) : (declarator != null && CdsAnnotations.CORE_MEDIA_TYPE.getOrDefault(declarator) != null ? "Edm.Stream" : CdsServiceEdmSchema.simpleType(((CdsSimpleType)type.as(CdsSimpleType.class)).getType()));
            return new FullQualifiedName(edmType);
        }
        return null;
    }

    private static String simpleType(CdsBaseType type) {
        return switch (type) {
            case CdsBaseType.UUID -> "Edm.Guid";
            case CdsBaseType.BOOLEAN -> "Edm.Boolean";
            case CdsBaseType.UINT8, CdsBaseType.HANA_TINYINT -> "Edm.Byte";
            case CdsBaseType.INT16, CdsBaseType.HANA_SMALLINT -> "Edm.Int16";
            case CdsBaseType.INT32, CdsBaseType.INTEGER -> "Edm.Int32";
            case CdsBaseType.INT64, CdsBaseType.INTEGER64 -> "Edm.Int64";
            case CdsBaseType.DECIMAL, CdsBaseType.HANA_SMALLDECIMAL -> "Edm.Decimal";
            case CdsBaseType.HANA_REAL -> "Edm.Single";
            case CdsBaseType.DOUBLE -> "Edm.Double";
            case CdsBaseType.DATE -> "Edm.Date";
            case CdsBaseType.TIME -> "Edm.TimeOfDay";
            case CdsBaseType.DATETIME, CdsBaseType.TIMESTAMP -> "Edm.DateTimeOffset";
            case CdsBaseType.STRING, CdsBaseType.LARGE_STRING, CdsBaseType.HANA_CHAR, CdsBaseType.HANA_NCHAR, CdsBaseType.HANA_VARCHAR, CdsBaseType.HANA_CLOB -> "Edm.String";
            case CdsBaseType.BINARY, CdsBaseType.LARGE_BINARY, CdsBaseType.HANA_BINARY -> "Edm.Binary";
            case CdsBaseType.HANA_ST_POINT -> "Edm.GeometryPoint";
            case CdsBaseType.HANA_ST_GEOMETRY -> "Edm.Geometry";
            default -> null;
        };
    }

    private static SimpleTypeProperties simpleTypeProperties(CdsSimpleType simpleType, CdsAnnotatable declarator) {
        Integer precision;
        Integer maxLength;
        Integer scale = null;
        String scaleAsString = null;
        SRID srid = null;
        if (declarator.findAnnotation("odata.Type").isPresent()) {
            maxLength = (Integer)declarator.getAnnotationValue("odata.MaxLength", null);
            precision = (Integer)declarator.getAnnotationValue("odata.Precision", null);
            Object scaleObj = declarator.getAnnotationValue("odata.Scale", null);
            if (scaleObj instanceof Integer) {
                Integer s;
                scale = s = (Integer)scaleObj;
            } else if (scaleObj instanceof String) {
                String s;
                scaleAsString = s = (String)scaleObj;
            }
            Object sridObj = declarator.getAnnotationValue("odata.SRID", null);
            if (sridObj != null) {
                srid = SRID.valueOf((String)sridObj.toString());
            }
        } else {
            maxLength = (Integer)simpleType.get("length");
            precision = simpleType.getType() == CdsBaseType.TIMESTAMP ? Integer.valueOf(7) : (Integer)simpleType.get("precision");
            Object scaleObj = simpleType.get("scale");
            if (scaleObj instanceof Integer) {
                Integer s;
                scale = s = (Integer)scaleObj;
            } else if (scaleObj instanceof String) {
                String s;
                scaleAsString = s = (String)scaleObj;
            }
            Object sridObj = simpleType.get("srid");
            if (sridObj != null) {
                srid = SRID.valueOf((String)sridObj.toString());
            }
        }
        return new SimpleTypeProperties(maxLength, precision, scale, scaleAsString, srid);
    }

    private static Stream<String> resolveKeys(CdsElement key) {
        if (key.getType().isAssociation()) {
            return AssociationAnalyzer.refElements((CdsElement)key).flatMap(CdsServiceEdmSchema::resolveKeys).map(k -> key.getName() + "_" + k);
        }
        return Stream.of(key.getName());
    }

    private static <T> List<T> addOrInit(List<T> list, T value) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        list.add(value);
        return list;
    }

    private record CdsEntityInfo(CdsEntity entity, EntityTypeKind kind) {
    }

    private static enum EntityTypeKind {
        DEFAULT,
        PARAMETERIZED_PARAMETERS,
        PARAMETERIZED_TYPE;

    }

    record SimpleTypeProperties(Integer maxLength, Integer precision, Integer scale, String scaleAsString, SRID srid) {
    }

    private record CdsOperationInfo<T extends CdsOperation>(T operation, CdsEntity boundTo) {
    }
}

