/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.provider;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.parser.JsonParser;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

class DefaultEdmxI18nProvider {
    private static final String PATH = "edmx/_i18n/i18n.json";
    private final Map<String, Map<String, String>> i18n;
    private final String hash;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DefaultEdmxI18nProvider create() {
        try (InputStream in = DefaultEdmxI18nProvider.class.getClassLoader().getResourceAsStream(PATH);){
            if (in != null) {
                HashingInputStream hasher = new HashingInputStream(Hashing.sha256(), in);
                Map i18nResources = (Map)JsonParser.map((Reader)new InputStreamReader((InputStream)hasher, StandardCharsets.UTF_8));
                String hash = hasher.hash().toString();
                DefaultEdmxI18nProvider defaultEdmxI18nProvider2 = new DefaultEdmxI18nProvider(i18nResources, hash);
                return defaultEdmxI18nProvider2;
            }
            DefaultEdmxI18nProvider defaultEdmxI18nProvider = new DefaultEdmxI18nProvider(Collections.emptyMap(), null);
            return defaultEdmxI18nProvider;
        }
        catch (IOException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_I18N_RESOURCES_FORMAT, new Object[]{PATH, e});
        }
    }

    private DefaultEdmxI18nProvider(Map<String, Map<String, String>> i18n, String hash) {
        this.i18n = i18n;
        this.hash = hash;
    }

    public String getHash() {
        return this.hash;
    }

    public Map<String, String> getTexts(Locale locale) {
        String localeString = locale == null ? "" : LocaleUtils.getLocaleString((Locale)locale);
        return this.i18n.getOrDefault(localeString, this.i18n.getOrDefault("", Collections.emptyMap()));
    }
}

