/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.provider;

import com.google.common.hash.Hashing;
import com.sap.cds.adapter.edmx.EdmxV4Provider;
import com.sap.cds.adapter.odata.v4.metadata.provider.DefaultEdmxI18nProvider;
import com.sap.cds.adapter.odata.v4.metadata.provider.EdmxI18nInputStream;
import com.sap.cds.adapter.odata.v4.metadata.provider.OlingoAwareEdmxV4Provider;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;

public class LocalizingEdmxProviderWrapper
implements OlingoAwareEdmxV4Provider {
    private static final DefaultEdmxI18nProvider i18nProvider = DefaultEdmxI18nProvider.create();
    private final EdmxV4Provider provider;
    private final Locale locale;

    public LocalizingEdmxProviderWrapper(EdmxV4Provider provider, Locale locale) {
        this.provider = provider;
        this.locale = locale;
    }

    public String getETag(String serviceName) {
        String eTag = this.provider.getETag(serviceName);
        String i18nHash = i18nProvider.getHash();
        if (i18nHash == null) {
            return eTag;
        }
        return Hashing.sha256().hashUnencodedChars((CharSequence)(eTag + i18nHash)).toString();
    }

    public InputStream getEdmx(String serviceName) {
        InputStream original = this.provider.getEdmx(serviceName);
        Map<String, String> i18n = i18nProvider.getTexts(this.locale);
        if (!i18n.isEmpty()) {
            return new EdmxI18nInputStream(original, i18n);
        }
        return original;
    }

    @Override
    public CsdlEdmProvider getEdmProvider(String serviceName) {
        CsdlEdmProvider csdlEdmProvider;
        EdmxV4Provider edmxV4Provider = this.provider;
        if (edmxV4Provider instanceof OlingoAwareEdmxV4Provider) {
            OlingoAwareEdmxV4Provider withEdm = (OlingoAwareEdmxV4Provider)edmxV4Provider;
            csdlEdmProvider = withEdm.getEdmProvider(serviceName);
        } else {
            csdlEdmProvider = null;
        }
        return csdlEdmProvider;
    }
}

