/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.processors.request;

import com.sap.cds.CdsData;
import com.sap.cds.CdsList;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.utils.TypeConverterUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.DeletedEntity;
import org.apache.olingo.commons.api.data.Delta;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public class PayloadProcessor {
    private final CdsRequestGlobals globals;

    public PayloadProcessor(CdsRequestGlobals globals) {
        this.globals = globals;
    }

    public Map<String, Object> getEntity(Entity entity) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        if (entity != null) {
            EdmEntityType entityType = null;
            for (Property property : entity.getProperties()) {
                propertyMap.put(property.getName(), this.getValue((Valuable)property));
            }
            for (Link link : entity.getNavigationLinks()) {
                String key = link.getTitle();
                if (link.getInlineEntity() != null) {
                    propertyMap.put(key, this.getEntity(link.getInlineEntity()));
                    continue;
                }
                if (link.getInlineEntitySet() instanceof Delta) {
                    CdsList deltaList = CdsList.create().delta();
                    propertyMap.put(key, deltaList);
                    Delta delta = (Delta)link.getInlineEntitySet();
                    for (Entity upsertedEntity : delta.getEntities()) {
                        deltaList.add((Object)CdsData.create(this.getEntity(upsertedEntity)));
                    }
                    entityType = entityType != null ? entityType : this.globals.getServiceMetadata().getEdm().getEntityType(new FullQualifiedName(entity.getType()));
                    EdmEntityType targetType = !delta.getDeletedEntities().isEmpty() ? entityType.getNavigationProperty(link.getTitle()).getType() : null;
                    for (DeletedEntity deletedEntity : delta.getDeletedEntities()) {
                        Map<String, Object> removedEntity = this.getEntity((Entity)deletedEntity);
                        URI uri = deletedEntity.getId();
                        if (uri != null) {
                            String path = deletedEntity.getId().getPath();
                            Map<String, Object> keyValues = PayloadProcessor.extractProperties(targetType, path);
                            removedEntity.putAll(keyValues);
                        }
                        deltaList.add((Object)CdsData.create(removedEntity).forRemoval());
                    }
                    continue;
                }
                if (link.getInlineEntitySet() != null) {
                    ArrayList<Map<String, Object>> entityCollection = new ArrayList<Map<String, Object>>();
                    for (Entity collectionEntity : link.getInlineEntitySet().getEntities()) {
                        entityCollection.add(this.getEntity(collectionEntity));
                    }
                    propertyMap.put(key, entityCollection);
                    continue;
                }
                propertyMap.put(key, null);
            }
            Iterator iterator = entity.getNavigationBindings().iterator();
            while (iterator.hasNext()) {
                Link bindingLink;
                EdmNavigationProperty navigationProperty = (entityType = entityType != null ? entityType : this.globals.getServiceMetadata().getEdm().getEntityType(new FullQualifiedName(entity.getType()))).getNavigationProperty((bindingLink = (Link)iterator.next()).getTitle());
                if (navigationProperty.isCollection()) {
                    throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
                }
                String link = bindingLink.getBindingLink();
                Map<String, Object> refProperties = PayloadProcessor.extractProperties(navigationProperty.getType(), link);
                propertyMap.put(navigationProperty.getName(), refProperties);
            }
        }
        return propertyMap;
    }

    private static Map<String, Object> extractProperties(EdmEntityType entityType, String link) {
        HashMap<String, Object> refProperties = new HashMap<String, Object>();
        String entityId = link.substring(link.indexOf(40) + 1, link.lastIndexOf(41));
        for (String keyValuePair : entityId.split(",")) {
            String value;
            String key;
            String[] pair = keyValuePair.split("=");
            if (pair.length == 1) {
                key = (String)entityType.getKeyPredicateNames().get(0);
                value = pair[0];
            } else {
                key = pair[0];
                value = pair[1];
            }
            refProperties.put(key, TypeConverterUtils.convertToType(entityType.getKeyPropertyRef(key).getProperty().getType(), value));
        }
        return refProperties;
    }

    public Object getValue(Valuable property) {
        Object value = property.getValue();
        if (value == null) {
            return null;
        }
        if (property.isCollection()) {
            ArrayList<Object> collection = new ArrayList<Object>();
            if (value instanceof EntityCollection) {
                for (Entity collectionEntity : ((EntityCollection)value).getEntities()) {
                    collection.add(this.getEntity(collectionEntity));
                }
            } else if (property.isComplex()) {
                for (ComplexValue complexValue : property.asCollection()) {
                    HashMap<String, Object> complex = new HashMap<String, Object>();
                    for (Property complexProperty : complexValue.getValue()) {
                        complex.put(complexProperty.getName(), this.getValue((Valuable)complexProperty));
                    }
                    collection.add(complex);
                }
            } else if (property.isPrimitive()) {
                for (Object primitiveValue : property.asCollection()) {
                    collection.add(TypeConverterUtils.getValueBasedOnTypeOfRequestPayload(property.getType(), primitiveValue));
                }
            }
            return collection;
        }
        if (value instanceof Entity) {
            return this.getEntity((Entity)value);
        }
        if (property.isComplex()) {
            HashMap<String, Object> complex = new HashMap<String, Object>();
            for (Property complexProperty : property.asComplex().getValue()) {
                complex.put(complexProperty.getName(), this.getValue((Valuable)complexProperty));
            }
            return complex;
        }
        if (property.isPrimitive()) {
            return TypeConverterUtils.getValueBasedOnTypeOfRequestPayload(property.getType(), property.getValue());
        }
        return null;
    }
}

