/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.adapter.odata.v4.query.apply.AggregateTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.ComputeTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.FilterByAggregateTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.FilterTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.GroupByTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.IdentityTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.OrderByTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.SearchTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.SkipTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.TopTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.Transformation;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.olingo.server.api.uri.queryoption.ApplyItem;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.apply.Aggregate;
import org.apache.olingo.server.api.uri.queryoption.apply.Compute;
import org.apache.olingo.server.api.uri.queryoption.apply.Concat;
import org.apache.olingo.server.api.uri.queryoption.apply.Filter;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupBy;
import org.apache.olingo.server.api.uri.queryoption.apply.OrderBy;
import org.apache.olingo.server.api.uri.queryoption.apply.Search;
import org.apache.olingo.server.api.uri.queryoption.apply.Skip;
import org.apache.olingo.server.api.uri.queryoption.apply.Top;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.core.uri.queryoption.ApplyOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.apply.IdentityImpl;

public class ApplyHandler {
    private final LinkedList<ApplyItem> items;
    private final List<ApplyOption> concats;
    private final ExpressionParser expressionParser;
    private Transformation previous;
    private static final ApplyHandler NOOP = new ApplyHandler((ApplyOption)new ApplyOptionImpl().add((ApplyItem)new IdentityImpl()), null, null);

    public ApplyHandler(ApplyOption applyOption, ExpressionParser expressionParser) {
        this(applyOption, IdentityTransformation.IDENTITY, expressionParser);
    }

    private ApplyHandler(ApplyOption applyOption, Transformation previous, ExpressionParser expressionParser) {
        LinkedList is = new LinkedList(applyOption.getApplyItems());
        ApplyItem last = (ApplyItem)is.getLast();
        if (last.getKind() == ApplyItem.Kind.CONCAT) {
            this.concats = ((Concat)last).getApplyOptions();
            is.remove(is.size() - 1);
        } else {
            this.concats = Collections.emptyList();
        }
        this.items = is;
        this.expressionParser = expressionParser;
        this.previous = previous;
    }

    public List<Transformation> getTransformations() {
        return this.items.stream().map(applyItem -> this.transformation((ApplyItem)applyItem)).collect(Collectors.toList());
    }

    private Transformation transformation(ApplyItem applyItem) {
        ApplyItem.Kind kind = applyItem.getKind();
        switch (kind) {
            case IDENTITY: {
                return IdentityTransformation.IDENTITY;
            }
            case AGGREGATE: {
                return new AggregateTransformation((Aggregate)applyItem, this.expressionParser);
            }
            case GROUP_BY: {
                ApplyItem item;
                List applyItems;
                GroupBy groupBy = (GroupBy)applyItem;
                ApplyOption apply = groupBy.getApplyOption();
                if (apply != null && (applyItems = apply.getApplyItems()).size() == 1 && (item = (ApplyItem)applyItems.get(0)).getKind() == ApplyItem.Kind.FILTER) {
                    Expression expression = ((Filter)item).getFilterOption().getExpression();
                    return new FilterByAggregateTransformation(groupBy.getGroupByItems(), expression, this.expressionParser);
                }
                return new GroupByTransformation(groupBy, this.expressionParser);
            }
            case ORDERBY: {
                return new OrderByTransformation((OrderBy)applyItem, this.expressionParser);
            }
            case TOP: {
                return new TopTransformation((Top)applyItem);
            }
            case SKIP: {
                return new SkipTransformation((Skip)applyItem);
            }
            case SEARCH: {
                return new SearchTransformation((Search)applyItem);
            }
            case FILTER: {
                return new FilterTransformation((Filter)applyItem, this.expressionParser);
            }
            case COMPUTE: {
                return new ComputeTransformation((Compute)applyItem, this.expressionParser);
            }
            case CONCAT: {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_CONCAT_LAST, new Object[]{kind.name()});
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_APPLY_OPTION, new Object[]{kind.name()});
    }

    private List<ApplyHandler> getConcats() {
        List<Transformation> ts = this.getTransformations();
        Transformation previous = ts.isEmpty() ? IdentityTransformation.IDENTITY : ts.get(ts.size() - 1);
        return this.concats.stream().map(o -> new ApplyHandler((ApplyOption)o, previous, this.expressionParser)).collect(Collectors.toList());
    }

    public List<Select<?>> transform(Select<?> select) {
        select = this.applyTransformations(select);
        List<ApplyHandler> concatHandlers = this.getConcats();
        ArrayList selects = new ArrayList();
        if (concatHandlers.isEmpty()) {
            selects.add(select);
        } else {
            for (ApplyHandler concatHandler : concatHandlers) {
                selects.addAll(concatHandler.transform(Select.copy(select)));
            }
        }
        return selects;
    }

    private Select<?> applyTransformations(Select<?> select) {
        List<Transformation> transformations = this.getTransformations();
        for (Transformation transformation : transformations) {
            if (transformation.requiresWrapping(this.previous)) {
                select = ApplyHandler.wrap(select);
            }
            select = (Select)transformation.apply(select);
            this.previous = transformation;
        }
        return select;
    }

    private static Select<StructuredType<?>> wrap(Select<?> select) {
        List items = select.items();
        List slis = items.stream().filter(CqnSelectListItem::isValue).map(i -> {
            String displayName = i.asValue().displayName();
            return CQL.get((String)displayName).as(displayName);
        }).collect(Collectors.toList());
        return Select.from(select).columns(slis);
    }

    public boolean hasConcat() {
        return !this.getConcats().isEmpty();
    }

    public static ApplyHandler create(ApplyOption applyOption, ExpressionParser expressionParser) {
        if (applyOption == null) {
            return NOOP;
        }
        return new ApplyHandler(applyOption, expressionParser);
    }
}

