/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.processors;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.sap.cds.Result;
import com.sap.cds.Row;
import com.sap.cds.Struct;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.AbstractODataProcessor;
import com.sap.cds.adapter.odata.v4.processors.request.CdsODataRequest;
import com.sap.cds.adapter.odata.v4.processors.response.CdsODataResponse;
import com.sap.cds.adapter.odata.v4.processors.response.ResultSetProcessor;
import com.sap.cds.adapter.odata.v4.query.NextLinkInfo;
import com.sap.cds.adapter.odata.v4.serializer.json.Apply2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.Apply2JsonBuilder;
import com.sap.cds.adapter.odata.v4.serializer.json.Complex2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.Complex2JsonBuilder;
import com.sap.cds.adapter.odata.v4.serializer.json.ComplexCollection2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.ComplexCollection2JsonBuilder;
import com.sap.cds.adapter.odata.v4.serializer.json.Entity2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.Entity2JsonBuilder;
import com.sap.cds.adapter.odata.v4.serializer.json.EntityCollection2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.EntityCollection2JsonBuilder;
import com.sap.cds.adapter.odata.v4.serializer.json.Primitive2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.Primitive2JsonBuilder;
import com.sap.cds.adapter.odata.v4.serializer.json.StructTypeHelper;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.api.PropertyInfo;
import com.sap.cds.adapter.odata.v4.serializer.json.options.Apply2JsonOptions;
import com.sap.cds.adapter.odata.v4.serializer.json.options.Primitive2JsonOptions;
import com.sap.cds.adapter.odata.v4.serializer.json.options.Struct2JsonOptions;
import com.sap.cds.adapter.odata.v4.serializer.json.options.StructCollection2JsonOptions;
import com.sap.cds.adapter.odata.v4.utils.ChangeSetContextAwareInputStream;
import com.sap.cds.adapter.odata.v4.utils.ETagHelper;
import com.sap.cds.adapter.odata.v4.utils.EdmUtils;
import com.sap.cds.adapter.odata.v4.utils.ODataUtils;
import com.sap.cds.impl.parser.JsonParser;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.changeset.ChangeSetContextSPI;
import com.sap.cds.services.pdf.PdfDocumentDescription;
import com.sap.cds.services.pdf.PdfService;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.ODataContent;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.prefer.Preferences;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.core.deserializer.helper.ExpandTreeBuilderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastODataProcessor
extends AbstractODataProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FastODataProcessor.class);
    private static final String SAP_DOCUMENT_DESCRIPTION = "SAP-Document-Description";
    private static final JsonFactory jsonFactory = new JsonFactory().configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true);

    public FastODataProcessor(CdsRequestGlobals globals) {
        super(globals);
        boolean fastSerializer = globals.getRuntime().getEnvironment().getCdsProperties().getOdataV4().getSerializer().isEnabled();
        logger.debug("Fast OData v4 JSON serializer = " + fastSerializer + ", buffered mode = " + this.isBuffered);
    }

    @Override
    public void processEntity(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType contentType) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            JsonRowODataContent odataContent = null;
            Row row = cdsResponse.getResult().first().orElse(null);
            if (row != null) {
                String locationPrefixTmp = null;
                boolean calculateKey = false;
                if (odataRequest.getMethod() != HttpMethod.GET && cdsRequest.getLastResource() == cdsRequest.getLastEntityResource(true)) {
                    locationPrefixTmp = odataRequest.getRawBaseUri() + odataRequest.getRawODataPath();
                    UriResource lastResource = cdsRequest.getLastResource();
                    calculateKey = !locationPrefixTmp.endsWith(")") && (lastResource.getKind() == UriResourceKind.entitySet || lastResource.getKind() == UriResourceKind.navigationProperty && ((UriResourceNavigation)lastResource).getProperty().isCollection());
                }
                String locationPrefix = locationPrefixTmp;
                EdmEntityType entityType = (EdmEntityType)cdsRequest.getResponseType();
                if (cdsResponse.getStatusCode() < 204 && cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                    ExpandOption expand = uriInfo.getExpandOption() != null ? uriInfo.getExpandOption() : EdmUtils.createExpand((EdmStructuredType)entityType, row);
                    ContextURL contextUrl = this.getContextUrl((CdsODataRequest)cdsRequest, false, uriInfo.getSelectOption(), expand);
                    Struct2JsonOptions options = Struct2JsonOptions.with(contentType, ODataUtils.getODataVersion(odataRequest), this.globals).contextURL(contextUrl).select(uriInfo.getSelectOption()).expand(expand).autoExpand(true).build();
                    Entity2Json entity2Json = Entity2JsonBuilder.createRoot(options, (EdmStructuredType)entityType, contentType);
                    FastODataProcessor.setLocationHeader(odataResponse, locationPrefix, calculateKey ? entity2Json.keyPredicate().apply((Map<String, Object>)row) : null);
                    odataContent = new JsonRowODataContent(entity2Json, row);
                } else {
                    FastODataProcessor.setLocationHeader(odataResponse, locationPrefix, ResultSetProcessor.getEntityId(entityType, row));
                }
                String eTag = ETagHelper.getEtagValue(this.globals, entityType, row);
                if (eTag != null) {
                    odataResponse.setHeader("ETag", eTag);
                }
            }
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, odataContent, contentType);
        });
    }

    @Override
    public void processEntities(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType contentType) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            void var7_11;
            Object var7_7 = null;
            Result result = cdsResponse.getResult();
            URI nextLink = null;
            NextLinkInfo nextLinkInfo = cdsResponse.getNextLinkInfo();
            if (nextLinkInfo != null) {
                nextLink = nextLinkInfo.getNextLink(odataRequest);
            }
            EdmEntityType entityType = (EdmEntityType)cdsRequest.getResponseType();
            ExpandOption expand = uriInfo.getExpandOption() != null ? uriInfo.getExpandOption() : (this.isActionOrFunction((CdsODataRequest)cdsRequest) ? EdmUtils.createExpand((EdmStructuredType)entityType, result) : ExpandTreeBuilderImpl.create().build());
            ContextURL contextUrl = this.getContextUrl((CdsODataRequest)cdsRequest, true, uriInfo.getSelectOption(), expand);
            if (uriInfo.getApplyOption() != null) {
                Apply2JsonOptions options = Apply2JsonOptions.with(contentType, ODataUtils.getODataVersion(odataRequest), this.globals).contextURL(contextUrl).count(uriInfo.getCountOption()).build();
                Apply2Json dynamic2Json = Apply2JsonBuilder.create(options, nextLink, result.inlineCount());
                JsonResultODataContent jsonResultODataContent = new JsonResultODataContent(dynamic2Json, (Iterable<?>)result);
            } else if (contentType.isCompatible(ContentType.APPLICATION_PDF)) {
                PdfService service = (PdfService)this.globals.getRuntime().getServiceCatalog().getService(PdfService.class, "PdfService$Default");
                if (service == null) throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.PDF_SERVICE_NOT_AVAILABLE, new Object[0]);
                Map headers = this.globals.getRuntime().getProvidedParameterInfo().getHeaders();
                PdfDocumentDescription docDesc = FastODataProcessor.parsePdfHeader((String)headers.get(SAP_DOCUMENT_DESCRIPTION));
                PdfContent pdfContent = new PdfContent(service, result, docDesc);
            } else {
                StructCollection2JsonOptions options = StructCollection2JsonOptions.with(contentType, ODataUtils.getODataVersion(odataRequest), this.globals).contextURL(contextUrl).select(uriInfo.getSelectOption()).expand(expand).count(uriInfo.getCountOption()).autoExpand(true).build();
                EntityCollection2Json entities2Json = EntityCollection2JsonBuilder.createRoot(options, (EdmStructuredType)entityType, contentType, nextLink, result.inlineCount());
                JsonResultODataContent jsonResultODataContent = new JsonResultODataContent(entities2Json, (Iterable<?>)result);
            }
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, (ODataContent)var7_11, contentType);
        });
    }

    @Override
    public void processSingleComplex(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            JsonRowODataContent odataContent = null;
            if (cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                Row row = cdsResponse.getResult().single();
                EdmStructuredType entityType = (EdmStructuredType)cdsRequest.getResponseType();
                ExpandOption expand = uriInfo.getExpandOption() != null ? uriInfo.getExpandOption() : EdmUtils.createExpand(entityType, row);
                ContextURL contextUrl = this.getContextUrl((CdsODataRequest)cdsRequest, false, uriInfo.getSelectOption(), expand);
                Struct2JsonOptions options = Struct2JsonOptions.with(responseFormat, ODataUtils.getODataVersion(odataRequest), this.globals).contextURL(contextUrl).select(uriInfo.getSelectOption()).expand(expand).build();
                Complex2Json entity2Json = Complex2JsonBuilder.createRoot(options, entityType, responseFormat);
                odataContent = new JsonRowODataContent(entity2Json, row);
            }
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, odataContent, responseFormat);
        });
    }

    @Override
    public void processCollectionComplex(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType contentType) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            JsonResultODataContent odataContent = null;
            Result result = cdsResponse.getResult();
            EdmStructuredType entityType = (EdmStructuredType)cdsRequest.getResponseType();
            ExpandOption expand = uriInfo.getExpandOption() != null ? uriInfo.getExpandOption() : (this.isActionOrFunction((CdsODataRequest)cdsRequest) ? EdmUtils.createExpand(entityType, result) : ExpandTreeBuilderImpl.create().build());
            ContextURL contextURL = this.getContextUrl((CdsODataRequest)cdsRequest, true, uriInfo.getSelectOption(), expand);
            if (cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                List payload;
                PropertyInfo complexPropertyInfo = StructTypeHelper.getPropertyInfo(cdsRequest);
                URI nextLink = null;
                NextLinkInfo nextLinkInfo = cdsResponse.getNextLinkInfo();
                if (nextLinkInfo != null) {
                    nextLink = nextLinkInfo.getNextLink(odataRequest);
                }
                StructCollection2JsonOptions options = StructCollection2JsonOptions.with(contentType, ODataUtils.getODataVersion(odataRequest), this.globals).contextURL(contextURL).select(uriInfo.getSelectOption()).expand(expand).count(uriInfo.getCountOption()).build();
                ComplexCollection2Json complex2Json = ComplexCollection2JsonBuilder.createRoot(options, entityType, contentType, nextLink, result.inlineCount());
                UriResourcePartTyped resource = cdsRequest.getLastTypedResource();
                if (resource.getKind().equals((Object)UriResourceKind.complexProperty)) {
                    Row row = result.single();
                    payload = (List)row.get((Object)complexPropertyInfo.getName());
                } else {
                    payload = result.list();
                }
                odataContent = new JsonResultODataContent(complex2Json, payload);
            }
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, odataContent, contentType);
        });
    }

    @Override
    public void processSinglePrimitive(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        ChangeSetContextSPI changeSetContext;
        boolean isStream = this.isGetStreamContext(odataRequest, uriInfo, requestFormat);
        if (isStream) {
            changeSetContext = ChangeSetContextSPI.open();
            this.globals.getUnclosedChangeSetTracker().set(true);
        } else {
            changeSetContext = null;
        }
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            Row row = cdsResponse.getResult().single();
            ContentType contentType = !StringUtils.isEmpty((String)cdsResponse.getContentType()) ? ContentType.create((String)cdsResponse.getContentType()) : responseFormat;
            Object odataContent = null;
            ContextURL contextURL = this.getContextUrl((CdsODataRequest)cdsRequest, false, null, null);
            PropertyInfo property = StructTypeHelper.getPropertyInfo(cdsRequest);
            if (isStream) {
                Data2Json<Map<String, Object>> primitive = StructTypeHelper.createPrimitive(property);
                Object value = primitive.getValue((Map<String, Object>)row);
                if (value != null && cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                    odataContent = new PrimitiveValueODataContent(value, contentType, changeSetContext);
                }
            } else {
                Primitive2JsonOptions options = Primitive2JsonOptions.with(contentType, ODataUtils.getODataVersion(odataRequest), this.globals).contextURL(contextURL).build();
                Primitive2Json primivitive2json = Primitive2JsonBuilder.create(options, property, contentType);
                odataContent = new JsonRowODataContent(primivitive2json, row);
            }
            this.setContentDispositionHeaderIfNotNull(odataResponse, cdsResponse.getContentDispositionFilename());
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, (ODataContent)odataContent, contentType);
        });
    }

    @Override
    public void processSinglePrimitiveValue(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            if (this.isValueRequestOnStreamProperty((CdsODataRequest)cdsRequest)) {
                UriResourcePartTyped lastTypedResource = cdsRequest.getLastTypedResource();
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.VALUE_ACCESS_NOT_ALLOWED, new Object[]{lastTypedResource.getSegmentValue()});
            }
            PrimitiveValueODataContent odataContent = null;
            Row row = cdsResponse.getResult().single();
            PropertyInfo propertyInfo = StructTypeHelper.getPropertyInfo(cdsRequest);
            Data2Json<Map<String, Object>> primitive = StructTypeHelper.createPrimitive(propertyInfo);
            Object value = primitive.getValue((Map<String, Object>)row);
            if (value != null && cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                odataContent = new PrimitiveValueODataContent(value, responseFormat, null);
            }
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, odataContent, responseFormat);
        });
    }

    @Override
    public void processCollectionPrimitive(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.processRequest(odataRequest, odataResponse, uriInfo, requestFormat, (cdsRequest, cdsResponse) -> {
            JsonRowODataContent odataContent = null;
            if (cdsRequest.getReturnPreference() != Preferences.Return.MINIMAL) {
                Row row = cdsResponse.getResult().single();
                ContextURL contextURL = this.getContextUrl((CdsODataRequest)cdsRequest, true, null, null);
                PropertyInfo property = StructTypeHelper.getPropertyInfo(cdsRequest);
                Primitive2JsonOptions options = Primitive2JsonOptions.with(responseFormat, ODataUtils.getODataVersion(odataRequest), this.globals).contextURL(contextURL).build();
                Primitive2Json primivitive2json = Primitive2JsonBuilder.create(options, property, responseFormat);
                odataContent = new JsonRowODataContent(primivitive2json, row);
            }
            this.setContentDispositionHeaderIfNotNull(odataResponse, cdsResponse.getContentDispositionFilename());
            this.setODataResponse((CdsODataRequest)cdsRequest, (CdsODataResponse)cdsResponse, odataResponse, odataContent, responseFormat);
        });
    }

    private static void serialize(Executable exec, OutputStream out) {
        try {
            exec.execute();
        }
        catch (Exception t) {
            String message = "ERROR: Failed to serialize payload ";
            logger.error(message, (Throwable)t);
            try {
                out.write(message.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERIALIZER_FAILED, new Object[0]);
            }
        }
    }

    private static PdfDocumentDescription parsePdfHeader(String header) {
        try {
            if (!StringUtils.isEmpty((String)header)) {
                String metaJson = new String(Base64.getDecoder().decode(header), StandardCharsets.UTF_8);
                Map pdfMeta = JsonParser.map((JsonNode)JsonParser.parseJson((String)metaJson));
                return (PdfDocumentDescription)Struct.access((Map)pdfMeta).as(PdfDocumentDescription.class);
            }
        }
        catch (Exception e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PDF_DESC_HEADER, new Object[0]);
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_PDF_DESC_HEADER, new Object[0]);
    }

    private static interface Executable {
        public void execute() throws IOException;
    }

    static final class JsonRowODataContent
    implements ODataContent {
        final Data2Json<Map<String, Object>> serializer;
        final Row row;

        JsonRowODataContent(Data2Json<Map<String, Object>> serializer, Row row) {
            this.serializer = serializer;
            this.row = row;
        }

        public void write(WritableByteChannel channel) {
            this.write(Channels.newOutputStream(channel));
        }

        public void write(OutputStream outputStream) {
            try (JsonGenerator json = jsonFactory.createGenerator(outputStream);){
                FastODataProcessor.serialize(() -> this.serializer.toJson((Map<String, Object>)this.row, json), outputStream);
            }
            catch (IOException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERIALIZER_FAILED, new Object[0]);
            }
        }
    }

    private final class PrimitiveValueODataContent
    implements ODataContent {
        private final Object value;
        private final ContentType contentType;
        private final ChangeSetContextSPI changeSetContext;

        PrimitiveValueODataContent(Object value, ContentType contentType, ChangeSetContextSPI changeSetContext) {
            this.value = value;
            this.contentType = contentType;
            this.changeSetContext = changeSetContext;
        }

        public void write(WritableByteChannel channel) {
            this.write(Channels.newOutputStream(channel));
        }

        public void write(OutputStream outputStream) {
            Object is = null;
            Object object = this.value;
            if (object instanceof Reader) {
                Reader reader = (Reader)object;
                is = new ChangeSetContextAwareInputStream((InputStream)new ReaderInputStream(reader, ODataUtils.getCharset(this.contentType)), this.changeSetContext, FastODataProcessor.this.globals.getUnclosedChangeSetTracker());
            } else {
                object = this.value;
                if (object instanceof InputStream) {
                    InputStream stream = (InputStream)object;
                    is = new ChangeSetContextAwareInputStream(stream, this.changeSetContext, FastODataProcessor.this.globals.getUnclosedChangeSetTracker());
                } else {
                    object = this.value;
                    if (object instanceof byte[]) {
                        byte[] bytes = (byte[])object;
                        is = new ByteArrayInputStream(Base64Variants.getDefaultVariant().encode(bytes).getBytes(StandardCharsets.UTF_8));
                    } else {
                        is = new ByteArrayInputStream(String.valueOf(this.value).getBytes());
                    }
                }
            }
            try (ChangeSetContextAwareInputStream s = is;){
                FastODataProcessor.serialize(() -> PrimitiveValueODataContent.lambda$write$0((InputStream)((Object)s), outputStream), outputStream);
            }
            catch (IOException t) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERIALIZER_FAILED, new Object[0]);
            }
        }

        private static /* synthetic */ void lambda$write$0(InputStream s, OutputStream outputStream) throws IOException {
            IOUtils.copy((InputStream)s, (OutputStream)outputStream);
        }
    }

    static final class JsonResultODataContent
    implements ODataContent {
        final Data2Json<Iterable<Map<String, Object>>> serializer;
        final Iterable<?> result;

        JsonResultODataContent(Data2Json<Iterable<Map<String, Object>>> serializer, Iterable<?> result) {
            this.serializer = serializer;
            this.result = result;
        }

        public void write(WritableByteChannel channel) {
            this.write(Channels.newOutputStream(channel));
        }

        public void write(OutputStream outputStream) {
            try (JsonGenerator json = jsonFactory.createGenerator(outputStream);){
                FastODataProcessor.serialize(() -> this.serializer.toJson(this.result, json), outputStream);
            }
            catch (IOException t) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERIALIZER_FAILED, new Object[0]);
            }
        }
    }

    private static final class PdfContent
    implements ODataContent {
        final PdfService serializer;
        final Result r;
        final PdfDocumentDescription docDesc;

        PdfContent(PdfService serializer, Result r, PdfDocumentDescription docDesc) {
            this.serializer = serializer;
            this.r = r;
            this.docDesc = docDesc;
        }

        public void write(WritableByteChannel channel) {
            this.write(Channels.newOutputStream(channel));
        }

        public void write(OutputStream outputStream) {
            try {
                FastODataProcessor.serialize(() -> this.serializer.export(this.docDesc, (Iterable)this.r, outputStream), outputStream);
            }
            catch (Exception e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERIALIZER_FAILED, new Object[0]);
            }
        }
    }
}

