/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.transformation.CqnTopLevelsTransformation;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.queryoption.apply.CustomFunction;

public class TopLevelsTransformation
implements CqnTopLevelsTransformation {
    private static final String NAME = "com.sap.vocabularies.Hierarchy.v1.TopLevels";
    private final CqnStructuredTypeRef hierarchyReference;
    private final String hierarchyQualifier;
    private final CqnElementRef nodeProperty;
    private final long levels;

    public TopLevelsTransformation(CqnStructuredTypeRef hierarchyReference, String hierarchyQualifier, CqnElementRef nodeProperty, long levels) {
        this.hierarchyReference = hierarchyReference;
        this.hierarchyQualifier = hierarchyQualifier;
        this.nodeProperty = nodeProperty;
        this.levels = levels;
    }

    public static CqnTopLevelsTransformation topLevels(CustomFunction custom, ExpressionParser expressionParser) {
        ParamConverter converter = new ParamConverter(custom, expressionParser);
        return new TopLevelsTransformation(converter.hierarchyReference(), converter.hierarchyQualifier(), converter.nodeProperty(), converter.levels());
    }

    private static String unquote(String text) {
        if (text.startsWith("'")) {
            text = text.substring(1, text.length() - 2);
        }
        return text;
    }

    public CqnStructuredTypeRef hierarchyReference() {
        return this.hierarchyReference;
    }

    public String hierarchyQualifier() {
        return this.hierarchyQualifier;
    }

    public CqnElementRef nodeProperty() {
        return this.nodeProperty;
    }

    public long levels() {
        return this.levels;
    }

    public static boolean handles(CustomFunction function) {
        return NAME.equals(function.getFunction().getFullQualifiedName().getFullQualifiedNameAsString());
    }

    private static class ParamConverter {
        private final ExpressionParser parser;
        private final Map<String, UriParameter> params;

        public ParamConverter(CustomFunction transformation, ExpressionParser expressionParser) {
            this.params = transformation.getParameters().stream().collect(Collectors.toMap(UriParameter::getName, p -> p));
            this.parser = expressionParser;
        }

        CqnStructuredTypeRef hierarchyReference() {
            UriParameter ref = this.params.get("HierarchyNodes");
            return this.parser.parseStructuredTypeRef(ref.getExpression());
        }

        String hierarchyQualifier() {
            return TopLevelsTransformation.unquote(this.params.get("HierarchyQualifier").getText());
        }

        CqnElementRef nodeProperty() {
            UriParameter node = this.params.get("NodeProperty");
            return CQL.get((String)node.getText());
        }

        long levels() {
            return this.params.containsKey("Levels") ? Long.parseLong(this.params.get("Levels").getText()) : -1L;
        }
    }
}

