/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.provider;

import com.sap.cds.adapter.odata.v4.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v4.metadata.provider.DefaultEdmxProvider;
import com.sap.cds.adapter.odata.v4.metadata.provider.OlingoAwareEdmxV4Provider;
import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.ModelId;
import com.sap.cds.mtx.impl.MetaDataAccessorImpl;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.LocaleUtils;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicEdmxProvider
implements OlingoAwareEdmxV4Provider {
    private static final String V4 = "v4";
    private static Logger log = LoggerFactory.getLogger(DynamicEdmxProvider.class);
    private final CdsRuntime runtime;
    private final DynamicModelUtils utils;
    private final DefaultEdmxProvider previous;
    private final MetaDataAccessor<MetadataInfo> accessor;

    public DynamicEdmxProvider(final CdsRuntime runtime, DynamicModelUtils utils, final DefaultEdmxProvider previous) {
        this.runtime = runtime;
        this.utils = utils;
        this.previous = previous;
        this.accessor = utils.createMetadataAccessor((MetaDataAccessorImpl.EdmxModelCreator)new MetaDataAccessorImpl.EdmxModelCreator<MetadataInfo>(){

            public MetadataInfo parse(String edmx, String serviceName) {
                try {
                    return MetadataInfo.create(serviceName, edmx.getBytes(StandardCharsets.UTF_8), runtime);
                }
                catch (Exception e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_METADATA, new Object[]{serviceName, e});
                }
            }

            public MetadataInfo getBaseModel(String serviceName) {
                return previous.getMetadataInfo(serviceName);
            }
        }, null, null);
    }

    public String getETag(String serviceName) {
        return this.getMetadataInfo(serviceName).getETag();
    }

    public InputStream getEdmx(String serviceName) {
        return this.getMetadataInfo(serviceName).getEdmx();
    }

    @Override
    public CsdlEdmProvider getEdmProvider(String serviceName) {
        return this.getMetadataInfo(serviceName).getEdmProvider();
    }

    private MetadataInfo getMetadataInfo(String serviceName) {
        if (this.utils.useStaticModel()) {
            return this.previous.getMetadataInfo(serviceName);
        }
        RequestContext requestContext = RequestContext.getCurrent((CdsRuntime)this.runtime);
        String localeString = null;
        if (!Boolean.TRUE.equals(this.runtime.getEnvironment().getCdsProperties().getOdataV4().getLazyI18n().isEnabled())) {
            Locale locale = requestContext.getParameterInfo().getLocale();
            localeString = locale != null ? LocaleUtils.getLocaleForBundle((Locale)locale).toString() : Locale.ENGLISH.getLanguage();
        }
        UserInfo userInfo = requestContext.getUserInfo();
        String tenant = userInfo.getTenant();
        Set features = requestContext.getFeatureTogglesInfo().getEnabledFeatureToggles().map(ft -> ft.getName()).collect(Collectors.toSet());
        ModelId modelId = ModelId.create((String)tenant).odata(serviceName, localeString, V4).features(features).build();
        int maxAgeSeconds = Integer.MAX_VALUE;
        log.debug("Retrieving model for service name '{}', locale '{}' and features {}", new Object[]{serviceName, localeString, features});
        try {
            return (MetadataInfo)this.accessor.getEdmx(modelId, maxAgeSeconds);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EDMX_READ_FAILED, new Object[]{serviceName, t});
        }
    }
}

