/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query;

import com.sap.cds.services.utils.StringUtils;
import java.net.URI;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;

public class NextLinkInfo {
    private static final String AMP = "&";
    private static final String SKIPTOKEN_ENC = "%24skiptoken";
    private static final String COUNT_ENC = "%24count";
    private String skipToken;

    public NextLinkInfo(String skipToken) {
        this.skipToken = skipToken;
    }

    public URI getNextLink(ODataRequest odataRequest) {
        String odataPath = odataRequest.getRawODataPath().substring(1);
        String query = StringUtils.isEmpty((String)odataRequest.getRawQueryPath()) ? "" : odataRequest.getRawQueryPath();
        String filteredQuery = "";
        if (!StringUtils.isEmpty((String)query)) {
            filteredQuery = Stream.of(query.split(AMP)).filter(q -> !q.startsWith(SystemQueryOptionKind.SKIPTOKEN.toString()) && !q.startsWith(SKIPTOKEN_ENC)).filter(q -> !q.startsWith(SystemQueryOptionKind.COUNT.toString()) && !q.startsWith(COUNT_ENC)).collect(Collectors.joining(AMP));
        }
        String skipTokenQuery = SystemQueryOptionKind.SKIPTOKEN + "=" + this.skipToken;
        String fullQuery = StringUtils.isEmpty((String)filteredQuery) ? skipTokenQuery : filteredQuery + AMP + skipTokenQuery;
        return URI.create(odataPath + "?" + fullQuery);
    }
}

