/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.adapter.odata.v4.query.apply.AggregateTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.ComputeTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.CustomTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.FilterTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.GroupByTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.HierarchySubsetTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.OrderByTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.SearchTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.SkipTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.TopLevelsTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.TopTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.server.api.uri.queryoption.ApplyItem;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.apply.Aggregate;
import org.apache.olingo.server.api.uri.queryoption.apply.Ancestors;
import org.apache.olingo.server.api.uri.queryoption.apply.Compute;
import org.apache.olingo.server.api.uri.queryoption.apply.Concat;
import org.apache.olingo.server.api.uri.queryoption.apply.CustomFunction;
import org.apache.olingo.server.api.uri.queryoption.apply.Descendants;
import org.apache.olingo.server.api.uri.queryoption.apply.Filter;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupBy;
import org.apache.olingo.server.api.uri.queryoption.apply.OrderBy;
import org.apache.olingo.server.api.uri.queryoption.apply.Search;
import org.apache.olingo.server.api.uri.queryoption.apply.Skip;
import org.apache.olingo.server.api.uri.queryoption.apply.Top;

public class ApplyConverter {
    private ExpressionParser expressionParser;

    public ApplyConverter(ExpressionParser expressionParser) {
        this.expressionParser = expressionParser;
    }

    public List<List<CqnTransformation>> unfoldAndConvert(List<ApplyItem> items) {
        ApplyItem last;
        int n = items.size();
        if (n > 0 && (last = items.get(n - 1)).getKind() == ApplyItem.Kind.CONCAT) {
            List<ApplyItem> stem = items.subList(0, n - 1);
            return this.unfoldConcats(stem, (Concat)last);
        }
        return List.of(items.stream().map(this::transformation).toList());
    }

    private List<List<CqnTransformation>> unfoldConcats(List<ApplyItem> stem, Concat concat) {
        List concats = concat.getApplyOptions();
        int m = concats.size();
        ArrayList<List<CqnTransformation>> all = new ArrayList<List<CqnTransformation>>(m);
        for (int i = 0; i < m; ++i) {
            ArrayList<ApplyItem> unfolded = new ArrayList<ApplyItem>(stem);
            List concatItems = ((ApplyOption)concats.get(i)).getApplyItems();
            unfolded.addAll(concatItems);
            all.addAll(this.unfoldAndConvert(unfolded));
        }
        return all;
    }

    private CqnTransformation transformation(ApplyItem applyItem) {
        ApplyItem.Kind kind = applyItem.getKind();
        switch (kind) {
            case IDENTITY: {
                return CqnTransformation.IDENTITY;
            }
            case AGGREGATE: {
                return new AggregateTransformation((Aggregate)applyItem, this.expressionParser);
            }
            case GROUP_BY: {
                return new GroupByTransformation((GroupBy)applyItem, this.expressionParser);
            }
            case ORDERBY: {
                return new OrderByTransformation((OrderBy)applyItem, this.expressionParser);
            }
            case TOP: {
                return new TopTransformation((Top)applyItem);
            }
            case SKIP: {
                return new SkipTransformation((Skip)applyItem);
            }
            case SEARCH: {
                return new SearchTransformation((Search)applyItem);
            }
            case FILTER: {
                return new FilterTransformation((Filter)applyItem, this.expressionParser);
            }
            case COMPUTE: {
                return new ComputeTransformation((Compute)applyItem, this.expressionParser);
            }
            case CUSTOM_FUNCTION: {
                CustomFunction function = (CustomFunction)applyItem;
                if (TopLevelsTransformation.handles(function)) {
                    return TopLevelsTransformation.topLevels(function, this.expressionParser);
                }
                return new CustomTransformation((CustomFunction)applyItem, this.expressionParser);
            }
            case ANCESTORS: {
                return HierarchySubsetTransformation.ancestors((Ancestors)applyItem, this.expressionParser);
            }
            case DESCENDANTS: {
                return HierarchySubsetTransformation.descendants((Descendants)applyItem, this.expressionParser);
            }
            case CONCAT: {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_CONCAT_LAST, new Object[]{kind.name()});
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_APPLY_OPTION, new Object[]{kind.name()});
    }
}

