/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.transformation.CqnSearchTransformation;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.apply.Search;
import org.apache.olingo.server.api.uri.queryoption.search.SearchBinary;
import org.apache.olingo.server.api.uri.queryoption.search.SearchExpression;

public class SearchTransformation
implements CqnSearchTransformation {
    private final CqnPredicate search;

    public SearchTransformation(Search odataSearch) {
        this.search = SearchTransformation.toCqnPredicate(odataSearch.getSearchOption().getSearchExpression());
    }

    public static Predicate convertSearchOption(SearchOption searchOption) {
        return SearchTransformation.toCqnPredicate(searchOption.getSearchExpression());
    }

    public static Predicate toCqnPredicate(SearchExpression expr) {
        if (expr.isSearchBinary()) {
            SearchBinary binary = expr.asSearchBinary();
            switch (binary.getOperator()) {
                case AND: {
                    return CQL.and((CqnPredicate)SearchTransformation.toCqnPredicate(binary.getLeftOperand()), (CqnPredicate)SearchTransformation.toCqnPredicate(binary.getRightOperand()));
                }
                case OR: {
                    return CQL.or((CqnPredicate)SearchTransformation.toCqnPredicate(binary.getLeftOperand()), (CqnPredicate)SearchTransformation.toCqnPredicate(binary.getRightOperand()));
                }
            }
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
        }
        if (expr.isSearchUnary()) {
            return CQL.not((CqnPredicate)SearchTransformation.toCqnPredicate((SearchExpression)expr.asSearchUnary().getOperand()));
        }
        if (expr.isSearchTerm()) {
            return CQL.search((String)expr.asSearchTerm().getSearchTerm());
        }
        throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
    }

    public CqnPredicate search() {
        return this.search;
    }
}

