/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.serializer.json;

import com.sap.cds.adapter.odata.v4.processors.request.CdsODataRequest;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.api.PropertyInfo;
import com.sap.cds.adapter.odata.v4.serializer.json.options.CdsODataOptions;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.Boolean2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.BooleanArray2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.Decimal2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.DecimalArray2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.Number2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.NumberArray2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.Object2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.ObjectArray2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.Stream2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.String2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.StringArray2Json;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBinary;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBoolean;
import org.apache.olingo.commons.core.edm.primitivetype.EdmByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDecimal;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt16;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt32;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSingle;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.serializer.utils.ExpandSelectHelper;

public final class StructTypeHelper {
    public static Set<List<String>> getSelectedPaths(SelectOption selectOption) {
        if (null == selectOption) {
            return null;
        }
        return selectOption.getSelectItems() == null ? null : ExpandSelectHelper.getSelectedPaths((List)selectOption.getSelectItems());
    }

    public static boolean isPropertySelected(Set<List<String>> selectedPaths, String propertyName) {
        boolean isSelected = true;
        if (null != selectedPaths) {
            isSelected = ExpandSelectHelper.isSelected(selectedPaths, (String)propertyName);
        }
        return isSelected;
    }

    public static Set<List<String>> getReducedSelectedPaths(Set<List<String>> selectedPaths, String propertyName) {
        if (null == selectedPaths) {
            return null;
        }
        return ExpandSelectHelper.getReducedSelectedPaths(selectedPaths, (String)propertyName);
    }

    public static Set<List<String>> getSelectedPaths(SelectOption selectOption, String propertyName) {
        if (null == selectOption) {
            return null;
        }
        return selectOption.getSelectItems() == null ? null : ExpandSelectHelper.getSelectedPaths((List)selectOption.getSelectItems(), (String)propertyName);
    }

    public static PropertyInfo getPropertyInfo(CdsODataRequest cdsRequest) {
        String name;
        EdmType responseType = cdsRequest.getResponseType();
        if (responseType.getKind() != EdmTypeKind.PRIMITIVE && responseType.getKind() != EdmTypeKind.COMPLEX) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EDM_TYPE, new Object[]{responseType.getKind()});
        }
        UriResourcePartTyped resource = cdsRequest.getLastTypedResource();
        return PropertyInfo.create(name, responseType, switch (resource.getKind()) {
            case UriResourceKind.primitiveProperty -> {
                UriResourcePrimitiveProperty p = (UriResourcePrimitiveProperty)resource;
                name = p.getProperty().getName();
                yield p.isCollection();
            }
            case UriResourceKind.complexProperty -> {
                UriResourceComplexProperty cp = (UriResourceComplexProperty)resource;
                name = cp.getProperty().getName();
                yield cp.isCollection();
            }
            case UriResourceKind.action -> {
                EdmAction action = ((UriResourceAction)resource).getAction();
                name = action.getName();
                yield action.getReturnType().isCollection();
            }
            case UriResourceKind.function -> {
                EdmFunction function = ((UriResourceFunction)resource).getFunction();
                name = function.getName();
                yield function.getReturnType().isCollection();
            }
            default -> throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{resource.getKind()});
        });
    }

    public static String2Json<Map<String, Object>> createPropertyMetaTypeSerializer(PropertyInfo propertyInfo, CdsODataOptions options) {
        String typeName = propertyInfo.getName() + options.getConstants().getType();
        EdmType type = propertyInfo.getType();
        if (type.getKind() == EdmTypeKind.ENUM || type.getKind() == EdmTypeKind.DEFINITION) {
            if (propertyInfo.isCollection()) {
                return String2Json.val(typeName, "#Collection(" + type.getFullQualifiedName().getFullQualifiedNameAsString() + ")");
            }
            return String2Json.val(typeName, "#" + type.getFullQualifiedName().getFullQualifiedNameAsString());
        }
        if (type.getKind() == EdmTypeKind.PRIMITIVE) {
            if (propertyInfo.isCollection()) {
                return String2Json.val(typeName, "#Collection(" + type.getFullQualifiedName().getName() + ")");
            }
            if (type != EdmBoolean.getInstance() && type != EdmDouble.getInstance() && type != EdmString.getInstance()) {
                return String2Json.val(typeName, "#" + type.getFullQualifiedName().getName());
            }
        } else if (type.getKind() == EdmTypeKind.COMPLEX) {
            if (propertyInfo.isCollection()) {
                return String2Json.val(typeName, "#Collection(" + type.getFullQualifiedName().getFullQualifiedNameAsString() + ")");
            }
        } else {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_PROPERTY_TYPE, new Object[]{type.getKind(), propertyInfo.getName()});
        }
        return null;
    }

    public static EdmStructuredType resolveEntityType(ServiceMetadata metadata, EdmStructuredType baseType, String derivedTypeName) {
        if (derivedTypeName == null || baseType.getFullQualifiedName().getFullQualifiedNameAsString().equals(derivedTypeName)) {
            return baseType;
        }
        EdmEntityType derivedType = metadata.getEdm().getEntityType(new FullQualifiedName(derivedTypeName));
        if (derivedType == null) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EDM_TYPE, new Object[]{derivedTypeName});
        }
        for (EdmEntityType type = derivedType.getBaseType(); type != null; type = type.getBaseType()) {
            if (!type.getFullQualifiedName().equals((Object)baseType.getFullQualifiedName())) continue;
            return derivedType;
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.WRONG_BASE_EDM_TYPE, new Object[]{baseType.getFullQualifiedName().getFullQualifiedNameAsString()});
    }

    public static Data2Json<Map<String, Object>> createPropertySerializer(PropertyInfo propertyInfo, CdsODataOptions options) {
        EdmType edmType = propertyInfo.getType();
        switch (edmType.getKind()) {
            case PRIMITIVE: 
            case DEFINITION: {
                return StructTypeHelper.createPrimitive(propertyInfo, options);
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EDM_TYPE, new Object[]{edmType.getKind()});
    }

    public static Data2Json<Map<String, Object>> createPrimitive(PropertyInfo propertyInfo, CdsODataOptions options) {
        return StructTypeHelper.createPrimitive(propertyInfo, propertyInfo.getName(), options);
    }

    public static Data2Json<Map<String, Object>> createPrimitive(PropertyInfo propertyInfo) {
        return StructTypeHelper.createPrimitive(propertyInfo, propertyInfo.getName(), null);
    }

    public static Data2Json<Map<String, Object>> createPrimitive(PropertyInfo propertyInfo, String label, CdsODataOptions options) {
        boolean isIEEE754Compatible = options != null && options.isIEEE754Compatible();
        EdmType edmType = propertyInfo.getType();
        if (edmType == EdmBoolean.getInstance()) {
            return StructTypeHelper.boolSerializer(label, propertyInfo);
        }
        if (edmType == EdmByte.getInstance() || edmType == EdmDouble.getInstance() || edmType == EdmInt16.getInstance() || edmType == EdmInt32.getInstance() || edmType == EdmSByte.getInstance() || edmType == EdmSingle.getInstance() || edmType == EdmInt64.getInstance() && !isIEEE754Compatible) {
            return StructTypeHelper.numberSerializer(label, propertyInfo);
        }
        if (edmType == EdmDecimal.getInstance() && !isIEEE754Compatible) {
            return StructTypeHelper.decimalSerializer(label, propertyInfo);
        }
        if (edmType == EdmBinary.getInstance()) {
            return StructTypeHelper.objectSerializer(label, propertyInfo);
        }
        if (edmType == EdmStream.getInstance()) {
            return StructTypeHelper.streamSerializer(label, propertyInfo);
        }
        return StructTypeHelper.stringSerializer(label, propertyInfo);
    }

    private static Data2Json<Map<String, Object>> stringSerializer(String label, PropertyInfo propertyType) {
        if (propertyType.isCollection()) {
            return StringArray2Json.val(label, StructTypeHelper.fromProperty(propertyType.getName()));
        }
        return String2Json.val(label, StructTypeHelper.fromProperty(propertyType.getName()));
    }

    private static Data2Json<Map<String, Object>> boolSerializer(String label, PropertyInfo propertyType) {
        if (propertyType.isCollection()) {
            return BooleanArray2Json.val(label, StructTypeHelper.fromProperty(propertyType.getName()));
        }
        return Boolean2Json.val(label, StructTypeHelper.fromProperty(propertyType.getName()));
    }

    private static Data2Json<Map<String, Object>> numberSerializer(String label, PropertyInfo propertyType) {
        if (propertyType.isCollection()) {
            return NumberArray2Json.val(label, StructTypeHelper.fromProperty(propertyType.getName()));
        }
        return Number2Json.val(label, StructTypeHelper.fromProperty(propertyType.getName()));
    }

    private static Data2Json<Map<String, Object>> decimalSerializer(String label, PropertyInfo propertyType) {
        if (propertyType.isCollection()) {
            return DecimalArray2Json.val(label, StructTypeHelper.fromProperty(propertyType.getName()));
        }
        return Decimal2Json.val(label, StructTypeHelper.fromProperty(propertyType.getName()));
    }

    private static Data2Json<Map<String, Object>> objectSerializer(String label, PropertyInfo propertyType) {
        if (propertyType.isCollection()) {
            return ObjectArray2Json.val(label, StructTypeHelper.fromProperty(propertyType.getName()));
        }
        return Object2Json.val(label, StructTypeHelper.fromProperty(propertyType.getName()));
    }

    private static Data2Json<Map<String, Object>> streamSerializer(String label, PropertyInfo propertyType) {
        return Stream2Json.val(label, StructTypeHelper.fromProperty(propertyType.getName()));
    }

    private static <T> Function<Map<String, Object>, T> fromProperty(String key) {
        return map -> map.get(key);
    }
}

