/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;
import java.io.IOException;
import java.util.function.Function;

public class String2Json<T>
implements Data2Json<T> {
    private final String name;
    private final Function<T, ?> valueFunc;

    private String2Json(String name, Function<T, ?> valueFunc) {
        this.name = name;
        this.valueFunc = valueFunc;
    }

    public static <T> String2Json<T> val(String name, Function<T, ?> valueFunc) {
        return new String2Json<T>(name, valueFunc);
    }

    public static <T> String2Json<T> val(String name, Object value) {
        return new String2Json<Object>(name, fixed -> value);
    }

    @Override
    public void toJson(T data, JsonGenerator json) throws IOException {
        Object value = this.valueFunc.apply(data);
        json.writeFieldName(this.name);
        if (value != null) {
            String strValue = String.valueOf(value);
            json.writeString(strValue);
        } else {
            json.writeNull();
        }
    }

    @Override
    public Object getValue(T data) {
        return this.valueFunc.apply(data);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

