/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsModelUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.apply.AggregateExpression;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;

public class ElementAggregator {
    private static final String SINGLE_VALUE = "singleValue";
    private final ExpressionParser expressionParser;

    public ElementAggregator(ExpressionParser expressionParser) {
        this.expressionParser = expressionParser;
    }

    public Value<?> genericAggregate(Expression expr, AggregateExpression.StandardMethod standardMethod) {
        Value value = (Value)this.expressionParser.parseValue(expr);
        return this.toFunctionCall(value, standardMethod);
    }

    public Value<?> customAggregate(List<UriResource> path) {
        ElementRef ref = CQL.get(this.expressionParser.toSegmentList(path));
        return this.customAggregate((ElementRef<Object>)ref);
    }

    public Value<?> customAggregate(ElementRef<Object> ref) {
        if (ref.lastSegment().equals("$count")) {
            return CQL.count();
        }
        CdsElement element = CdsModelUtils.element((CdsStructuredType)this.expressionParser.getRootType(), ref);
        String methodName = this.getAggregationMethodName(element);
        return this.toFunctionCall(ref, methodName);
    }

    private String getAggregationMethodName(CdsElement element) {
        HashMap valueMap = (HashMap)CdsAnnotations.AGGREGATION_DEFAULT.getOrValue((CdsAnnotatable)element, new HashMap());
        String value = (String)valueMap.get("#");
        if (value != null) {
            return value;
        }
        boolean isCurrencyCode = CdsAnnotations.SEMANTICS_CURRENCY_CODE.isTrue((CdsAnnotatable)element);
        boolean isUnitOfMeasure = CdsAnnotations.SEMANTICS_UNIT_OF_MEASURE.isTrue((CdsAnnotatable)element);
        if (isCurrencyCode || isUnitOfMeasure) {
            return SINGLE_VALUE;
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_CUSTOM_AGGREGATE_DEFINED, new Object[]{element});
    }

    Value<?> toFunctionCall(ElementRef<Object> ref, String methodName) {
        Value functionCall;
        switch (methodName) {
            case "AVG": 
            case "AVERAGE": {
                functionCall = ref.average();
                break;
            }
            case "COUNT": {
                functionCall = CQL.func((String)methodName, (CqnValue[])new CqnValue[]{ref}).type(Long.class);
                break;
            }
            case "COUNT_DISTINCT": {
                functionCall = ref.countDistinct();
                break;
            }
            case "MIN": 
            case "MAX": 
            case "SUM": 
            case "singleValue": {
                functionCall = CQL.func((String)methodName, (CqnValue[])new CqnValue[]{ref});
                this.type((Value<?>)ref).ifPresent(arg_0 -> ((Value)functionCall).type(arg_0));
                break;
            }
            default: {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNKONWN_AGGREGATION_METHOD, new Object[]{methodName});
            }
        }
        return functionCall;
    }

    public Value<?> toFunctionCall(Value<?> value, AggregateExpression.StandardMethod standardMethod) {
        Value functionCall;
        switch (standardMethod) {
            case AVERAGE: {
                functionCall = value.average();
                break;
            }
            case COUNT_DISTINCT: {
                functionCall = value.countDistinct();
                break;
            }
            case MIN: {
                functionCall = value.min();
                this.type(value).ifPresent(arg_0 -> ((Value)functionCall).type(arg_0));
                break;
            }
            case MAX: {
                functionCall = value.max();
                this.type(value).ifPresent(arg_0 -> ((Value)functionCall).type(arg_0));
                break;
            }
            default: {
                functionCall = CQL.func((String)standardMethod.name(), (CqnValue[])new CqnValue[]{value});
            }
        }
        return functionCall;
    }

    private Optional<CdsBaseType> type(Value<?> value) {
        CdsElement element;
        CdsType t;
        if (value.isRef() && (t = (element = CdsModelUtils.element((CdsStructuredType)this.expressionParser.getRootType(), (CqnElementRef)value.asRef())).getType()).isSimple()) {
            return Optional.ofNullable(((CdsSimpleType)t.as(CdsSimpleType.class)).getType());
        }
        return Optional.empty();
    }
}

