/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;

public class NumberArray2Json<T>
implements Data2Json<T> {
    private final String name;
    private final Function<T, List<Number>> valueFunc;

    private NumberArray2Json(String name, Function<T, List<Number>> valueFunc) {
        this.name = name;
        this.valueFunc = valueFunc;
    }

    public static <T> NumberArray2Json<T> val(String name, Function<T, List<Number>> valueFunc) {
        return new NumberArray2Json<T>(name, valueFunc);
    }

    @Override
    public void toJson(T data, JsonGenerator json) throws IOException {
        List<Number> values = this.valueFunc.apply(data);
        json.writeFieldName(this.name);
        json.writeStartArray();
        if (values != null) {
            for (Number v : values) {
                if (v != null) {
                    json.writeNumber(String.valueOf(v));
                    continue;
                }
                json.writeNull();
            }
        }
        json.writeEndArray();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

