/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.adapter.odata.v4.query.apply.AncestorsTransformation;
import com.sap.cds.adapter.odata.v4.query.apply.ApplyHandler;
import com.sap.cds.adapter.odata.v4.query.apply.DescendantsTransformation;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.transformation.CqnAncestorsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import java.util.List;
import org.apache.olingo.server.api.uri.queryoption.apply.Ancestors;
import org.apache.olingo.server.api.uri.queryoption.apply.Descendants;
import org.apache.olingo.server.api.uri.queryoption.apply.HierarchicalSubsetTransformation;

public abstract class HierarchySubsetTransformation {
    private final CqnStructuredTypeRef hierarchyReference;
    private final String hierarchyQualifier;
    private final CqnElementRef nodeProperty;
    private final List<CqnTransformation> transformations;
    private final int distanceFromStart;
    private final boolean keepStart;

    public HierarchySubsetTransformation(CqnStructuredTypeRef hierarchyReference, String hierarchyQualifier, CqnElementRef nodeProperty, List<CqnTransformation> transformations, int distanceFromStart, boolean keepStart) {
        this.hierarchyReference = hierarchyReference;
        this.hierarchyQualifier = hierarchyQualifier;
        this.nodeProperty = nodeProperty;
        this.transformations = transformations;
        this.distanceFromStart = distanceFromStart;
        this.keepStart = keepStart;
    }

    public static CqnAncestorsTransformation ancestors(Ancestors ancestors, ExpressionParser expressionParser) {
        ParamConverter converter = new ParamConverter((HierarchicalSubsetTransformation)ancestors, expressionParser);
        return new AncestorsTransformation((CqnStructuredTypeRef)converter.hierarchyReference(), converter.hierarchyQualifier(), converter.nodeProperty(), converter.transformations(), converter.distanctFromStart(), converter.keepStart());
    }

    public static CqnTransformation descendants(Descendants descendants, ExpressionParser expressionParser) {
        ParamConverter converter = new ParamConverter((HierarchicalSubsetTransformation)descendants, expressionParser);
        return new DescendantsTransformation((CqnStructuredTypeRef)converter.hierarchyReference(), converter.hierarchyQualifier(), converter.nodeProperty(), converter.transformations(), converter.distanctFromStart(), converter.keepStart());
    }

    public CqnStructuredTypeRef hierarchyReference() {
        return this.hierarchyReference;
    }

    public String hierarchyQualifier() {
        return this.hierarchyQualifier;
    }

    public CqnElementRef nodeProperty() {
        return this.nodeProperty;
    }

    public List<CqnTransformation> transformations() {
        return this.transformations;
    }

    public int distanceFromStart() {
        return this.distanceFromStart;
    }

    public boolean keepStart() {
        return this.keepStart;
    }

    private static class ParamConverter {
        private ExpressionParser parser;
        private HierarchicalSubsetTransformation transformation;

        public ParamConverter(HierarchicalSubsetTransformation transformation, ExpressionParser expressionParser) {
            this.transformation = transformation;
            this.parser = expressionParser;
        }

        StructuredTypeRef hierarchyReference() {
            return CQL.to(this.parser.toSegmentList(this.transformation.getHierarchyReference())).asRef();
        }

        String hierarchyQualifier() {
            return this.transformation.getHierarchyQualifier();
        }

        CqnElementRef nodeProperty() {
            return CQL.get(this.parser.toSegmentList(this.transformation.getNodeProperty()));
        }

        List<CqnTransformation> transformations() {
            List applies = this.transformation.getTransformations();
            ApplyHandler applyHandler = new ApplyHandler(applies, this.parser);
            List<CqnTransformation> transformations = applyHandler.getTransformations(0);
            return transformations;
        }

        int distanctFromStart() {
            return this.transformation.getDistanceFromStart() != null ? this.transformation.getDistanceFromStart() : -1;
        }

        boolean keepStart() {
            return this.transformation.isKeepStart() == Boolean.TRUE;
        }
    }
}

